/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.EntityGraphFactory;
import org.springframework.data.jpa.repository.support.FluentQuerySupport;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.util.Assert;

class FetchableFluentQueryByPredicate<S, R>
extends FluentQuerySupport<S, R>
implements FluentQuery.FetchableFluentQuery<R> {
    private final Predicate predicate;
    private final Function<Sort, AbstractJPAQuery<?, ?>> finder;
    private final BiFunction<Sort, Pageable, AbstractJPAQuery<?, ?>> pagedFinder;
    private final Function<Predicate, Long> countOperation;
    private final Function<Predicate, Boolean> existsOperation;
    private final EntityManager entityManager;

    public FetchableFluentQueryByPredicate(Predicate predicate, Class<S> entityType, Function<Sort, AbstractJPAQuery<?, ?>> finder, BiFunction<Sort, Pageable, AbstractJPAQuery<?, ?>> pagedFinder, Function<Predicate, Long> countOperation, Function<Predicate, Boolean> existsOperation, EntityManager entityManager) {
        this(predicate, entityType, entityType, Sort.unsorted(), Collections.emptySet(), finder, pagedFinder, countOperation, existsOperation, entityManager);
    }

    private FetchableFluentQueryByPredicate(Predicate predicate, Class<S> entityType, Class<R> resultType, Sort sort, Collection<String> properties, Function<Sort, AbstractJPAQuery<?, ?>> finder, BiFunction<Sort, Pageable, AbstractJPAQuery<?, ?>> pagedFinder, Function<Predicate, Long> countOperation, Function<Predicate, Boolean> existsOperation, EntityManager entityManager) {
        super(resultType, sort, properties, entityType);
        this.predicate = predicate;
        this.finder = finder;
        this.pagedFinder = pagedFinder;
        this.countOperation = countOperation;
        this.existsOperation = existsOperation;
        this.entityManager = entityManager;
    }

    @Override
    public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
        Assert.notNull((Object)sort, "Sort must not be null!");
        return new FetchableFluentQueryByPredicate<S, R>(this.predicate, this.entityType, this.resultType, this.sort.and(sort), this.properties, this.finder, this.pagedFinder, this.countOperation, this.existsOperation, this.entityManager);
    }

    @Override
    public <NR> FluentQuery.FetchableFluentQuery<NR> as(Class<NR> resultType) {
        Assert.notNull(resultType, "Projection target type must not be null!");
        if (!resultType.isInterface()) {
            throw new UnsupportedOperationException("Class-based DTOs are not yet supported.");
        }
        return new FetchableFluentQueryByPredicate<S, NR>(this.predicate, this.entityType, resultType, this.sort, this.properties, this.finder, this.pagedFinder, this.countOperation, this.existsOperation, this.entityManager);
    }

    @Override
    public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
        return new FetchableFluentQueryByPredicate<S, R>(this.predicate, this.entityType, this.resultType, this.sort, this.mergeProperties(properties), this.finder, this.pagedFinder, this.countOperation, this.existsOperation, this.entityManager);
    }

    @Override
    public R oneValue() {
        List results = ((AbstractJPAQuery)this.createSortedAndProjectedQuery().limit(2L)).fetch();
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        return results.isEmpty() ? null : (R)this.getConversionFunction().apply(results.get(0));
    }

    @Override
    public R firstValue() {
        List results = ((AbstractJPAQuery)this.createSortedAndProjectedQuery().limit(1L)).fetch();
        return results.isEmpty() ? null : (R)this.getConversionFunction().apply(results.get(0));
    }

    @Override
    public List<R> all() {
        return this.convert(this.createSortedAndProjectedQuery().fetch());
    }

    @Override
    public Page<R> page(Pageable pageable) {
        return pageable.isUnpaged() ? new PageImpl<R>(this.all()) : this.readPage(pageable);
    }

    @Override
    public Stream<R> stream() {
        return this.createSortedAndProjectedQuery().stream().map(this.getConversionFunction());
    }

    @Override
    public long count() {
        return this.countOperation.apply(this.predicate);
    }

    @Override
    public boolean exists() {
        return this.existsOperation.apply(this.predicate);
    }

    private AbstractJPAQuery<?, ?> createSortedAndProjectedQuery() {
        AbstractJPAQuery<?, ?> query2 = this.finder.apply(this.sort);
        if (!this.properties.isEmpty()) {
            query2.setHint("javax.persistence.fetchgraph", EntityGraphFactory.create(this.entityManager, this.entityType, this.properties));
        }
        return query2;
    }

    private Page<R> readPage(Pageable pageable) {
        AbstractJPAQuery<?, ?> pagedQuery = this.pagedFinder.apply(this.sort, pageable);
        List<R> paginatedResults = this.convert(pagedQuery.fetch());
        return PageableExecutionUtils.getPage(paginatedResults, pageable, () -> this.countOperation.apply(this.predicate));
    }

    private List<R> convert(List<?> resultList) {
        Function<Object, R> conversionFunction = this.getConversionFunction();
        ArrayList<R> mapped = new ArrayList<R>(resultList.size());
        for (Object o : resultList) {
            mapped.add(conversionFunction.apply(o));
        }
        return mapped;
    }

    private Function<Object, R> getConversionFunction() {
        return this.getConversionFunction(this.entityType, this.resultType);
    }
}

