/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.BlockDeviceMapping;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.Ebs;
import com.amazonaws.services.autoscaling.model.InstanceMonitoring;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateLaunchConfigurationRequestMarshaller
implements Marshaller<Request<CreateLaunchConfigurationRequest>, CreateLaunchConfigurationRequest> {
    @Override
    public Request<CreateLaunchConfigurationRequest> marshall(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) {
        if (createLaunchConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateLaunchConfigurationRequest> request = new DefaultRequest<CreateLaunchConfigurationRequest>(createLaunchConfigurationRequest, "AmazonAutoScaling");
        request.addParameter("Action", "CreateLaunchConfiguration");
        request.addParameter("Version", "2011-01-01");
        if (createLaunchConfigurationRequest.getLaunchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringUtils.fromString(createLaunchConfigurationRequest.getLaunchConfigurationName()));
        }
        if (createLaunchConfigurationRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(createLaunchConfigurationRequest.getImageId()));
        }
        if (createLaunchConfigurationRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString(createLaunchConfigurationRequest.getKeyName()));
        }
        List<String> securityGroupsList = createLaunchConfigurationRequest.getSecurityGroups();
        int securityGroupsListIndex = 1;
        for (String securityGroupsListValue : securityGroupsList) {
            if (securityGroupsListValue != null) {
                request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringUtils.fromString(securityGroupsListValue));
            }
            ++securityGroupsListIndex;
        }
        if (createLaunchConfigurationRequest.getClassicLinkVPCId() != null) {
            request.addParameter("ClassicLinkVPCId", StringUtils.fromString(createLaunchConfigurationRequest.getClassicLinkVPCId()));
        }
        List<String> classicLinkVPCSecurityGroupsList = createLaunchConfigurationRequest.getClassicLinkVPCSecurityGroups();
        int classicLinkVPCSecurityGroupsListIndex = 1;
        for (String classicLinkVPCSecurityGroupsListValue : classicLinkVPCSecurityGroupsList) {
            if (classicLinkVPCSecurityGroupsListValue != null) {
                request.addParameter("ClassicLinkVPCSecurityGroups.member." + classicLinkVPCSecurityGroupsListIndex, StringUtils.fromString(classicLinkVPCSecurityGroupsListValue));
            }
            ++classicLinkVPCSecurityGroupsListIndex;
        }
        if (createLaunchConfigurationRequest.getUserData() != null) {
            request.addParameter("UserData", StringUtils.fromString(createLaunchConfigurationRequest.getUserData()));
        }
        if (createLaunchConfigurationRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(createLaunchConfigurationRequest.getInstanceId()));
        }
        if (createLaunchConfigurationRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString(createLaunchConfigurationRequest.getInstanceType()));
        }
        if (createLaunchConfigurationRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString(createLaunchConfigurationRequest.getKernelId()));
        }
        if (createLaunchConfigurationRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString(createLaunchConfigurationRequest.getRamdiskId()));
        }
        List<BlockDeviceMapping> blockDeviceMappingsList = createLaunchConfigurationRequest.getBlockDeviceMappings();
        int blockDeviceMappingsListIndex = 1;
        for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
            BlockDeviceMapping blockDeviceMappingMember = blockDeviceMappingsListValue;
            if (blockDeviceMappingMember != null) {
                Ebs ebsEbs;
                if (blockDeviceMappingMember.getVirtualName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(blockDeviceMappingMember.getVirtualName()));
                }
                if (blockDeviceMappingMember.getDeviceName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(blockDeviceMappingMember.getDeviceName()));
                }
                if ((ebsEbs = blockDeviceMappingMember.getEbs()) != null) {
                    if (ebsEbs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString(ebsEbs.getSnapshotId()));
                    }
                    if (ebsEbs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger(ebsEbs.getVolumeSize()));
                    }
                    if (ebsEbs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString(ebsEbs.getVolumeType()));
                    }
                    if (ebsEbs.isDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebsEbs.isDeleteOnTermination()));
                    }
                    if (ebsEbs.getIops() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger(ebsEbs.getIops()));
                    }
                }
                if (blockDeviceMappingMember.isNoDevice() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromBoolean(blockDeviceMappingMember.isNoDevice()));
                }
            }
            ++blockDeviceMappingsListIndex;
        }
        InstanceMonitoring instanceMonitoringInstanceMonitoring = createLaunchConfigurationRequest.getInstanceMonitoring();
        if (instanceMonitoringInstanceMonitoring != null && instanceMonitoringInstanceMonitoring.isEnabled() != null) {
            request.addParameter("InstanceMonitoring.Enabled", StringUtils.fromBoolean(instanceMonitoringInstanceMonitoring.isEnabled()));
        }
        if (createLaunchConfigurationRequest.getSpotPrice() != null) {
            request.addParameter("SpotPrice", StringUtils.fromString(createLaunchConfigurationRequest.getSpotPrice()));
        }
        if (createLaunchConfigurationRequest.getIamInstanceProfile() != null) {
            request.addParameter("IamInstanceProfile", StringUtils.fromString(createLaunchConfigurationRequest.getIamInstanceProfile()));
        }
        if (createLaunchConfigurationRequest.isEbsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean(createLaunchConfigurationRequest.isEbsOptimized()));
        }
        if (createLaunchConfigurationRequest.isAssociatePublicIpAddress() != null) {
            request.addParameter("AssociatePublicIpAddress", StringUtils.fromBoolean(createLaunchConfigurationRequest.isAssociatePublicIpAddress()));
        }
        if (createLaunchConfigurationRequest.getPlacementTenancy() != null) {
            request.addParameter("PlacementTenancy", StringUtils.fromString(createLaunchConfigurationRequest.getPlacementTenancy()));
        }
        return request;
    }
}

