/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeVpcClassicLinkRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeVpcClassicLinkRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<DescribeVpcClassicLinkRequest> {
    private ListWithAutoConstructFlag<String> vpcIds;
    private ListWithAutoConstructFlag<Filter> filters;

    public List<String> getVpcIds() {
        if (this.vpcIds == null) {
            this.vpcIds = new ListWithAutoConstructFlag();
            this.vpcIds.setAutoConstruct(true);
        }
        return this.vpcIds;
    }

    public void setVpcIds(Collection<String> vpcIds) {
        if (vpcIds == null) {
            this.vpcIds = null;
            return;
        }
        ListWithAutoConstructFlag vpcIdsCopy = new ListWithAutoConstructFlag(vpcIds.size());
        vpcIdsCopy.addAll(vpcIds);
        this.vpcIds = vpcIdsCopy;
    }

    public DescribeVpcClassicLinkRequest withVpcIds(String ... vpcIds) {
        if (this.getVpcIds() == null) {
            this.setVpcIds(new ArrayList<String>(vpcIds.length));
        }
        for (String value : vpcIds) {
            this.getVpcIds().add(value);
        }
        return this;
    }

    public DescribeVpcClassicLinkRequest withVpcIds(Collection<String> vpcIds) {
        if (vpcIds == null) {
            this.vpcIds = null;
        } else {
            ListWithAutoConstructFlag vpcIdsCopy = new ListWithAutoConstructFlag(vpcIds.size());
            vpcIdsCopy.addAll(vpcIds);
            this.vpcIds = vpcIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeVpcClassicLinkRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeVpcClassicLinkRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeVpcClassicLinkRequest> getDryRunRequest() {
        Request<DescribeVpcClassicLinkRequest> request = new DescribeVpcClassicLinkRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVpcIds() != null) {
            sb.append("VpcIds: " + this.getVpcIds() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVpcIds() == null ? 0 : this.getVpcIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkRequest)) {
            return false;
        }
        DescribeVpcClassicLinkRequest other = (DescribeVpcClassicLinkRequest)obj;
        if (other.getVpcIds() == null ^ this.getVpcIds() == null) {
            return false;
        }
        if (other.getVpcIds() != null && !other.getVpcIds().equals(this.getVpcIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }
}

