/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.transform.GroupIdentifierStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.InstanceStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ReservationStaxUnmarshaller
implements Unmarshaller<Reservation, StaxUnmarshallerContext> {
    private static ReservationStaxUnmarshaller instance;

    @Override
    public Reservation unmarshall(StaxUnmarshallerContext context) throws Exception {
        Reservation reservation = new Reservation();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return reservation;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("reservationId", targetDepth)) {
                    reservation.setReservationId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ownerId", targetDepth)) {
                    reservation.setOwnerId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("requesterId", targetDepth)) {
                    reservation.setRequesterId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupSet/item", targetDepth)) {
                    reservation.getGroups().add(GroupIdentifierStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupSet/item/groupName", targetDepth)) {
                    reservation.getGroupNames().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("instancesSet/item", targetDepth)) continue;
                reservation.getInstances().add(InstanceStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return reservation;
    }

    public static ReservationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ReservationStaxUnmarshaller();
        }
        return instance;
    }
}

