/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeTasksRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String cluster;
    private ListWithAutoConstructFlag<String> tasks;

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public DescribeTasksRequest withCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public List<String> getTasks() {
        if (this.tasks == null) {
            this.tasks = new ListWithAutoConstructFlag();
            this.tasks.setAutoConstruct(true);
        }
        return this.tasks;
    }

    public void setTasks(Collection<String> tasks) {
        if (tasks == null) {
            this.tasks = null;
            return;
        }
        ListWithAutoConstructFlag tasksCopy = new ListWithAutoConstructFlag(tasks.size());
        tasksCopy.addAll(tasks);
        this.tasks = tasksCopy;
    }

    public DescribeTasksRequest withTasks(String ... tasks) {
        if (this.getTasks() == null) {
            this.setTasks(new ArrayList<String>(tasks.length));
        }
        for (String value : tasks) {
            this.getTasks().add(value);
        }
        return this;
    }

    public DescribeTasksRequest withTasks(Collection<String> tasks) {
        if (tasks == null) {
            this.tasks = null;
        } else {
            ListWithAutoConstructFlag tasksCopy = new ListWithAutoConstructFlag(tasks.size());
            tasksCopy.addAll(tasks);
            this.tasks = tasksCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: " + this.getCluster() + ",");
        }
        if (this.getTasks() != null) {
            sb.append("Tasks: " + this.getTasks());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getTasks() == null ? 0 : this.getTasks().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTasksRequest)) {
            return false;
        }
        DescribeTasksRequest other = (DescribeTasksRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getTasks() == null ^ this.getTasks() == null) {
            return false;
        }
        return other.getTasks() == null || other.getTasks().equals(this.getTasks());
    }
}

