/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.Failure;
import com.amazonaws.services.ecs.model.Task;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RunTaskResult
implements Serializable {
    private ListWithAutoConstructFlag<Task> tasks;
    private ListWithAutoConstructFlag<Failure> failures;

    public List<Task> getTasks() {
        if (this.tasks == null) {
            this.tasks = new ListWithAutoConstructFlag();
            this.tasks.setAutoConstruct(true);
        }
        return this.tasks;
    }

    public void setTasks(Collection<Task> tasks) {
        if (tasks == null) {
            this.tasks = null;
            return;
        }
        ListWithAutoConstructFlag tasksCopy = new ListWithAutoConstructFlag(tasks.size());
        tasksCopy.addAll(tasks);
        this.tasks = tasksCopy;
    }

    public RunTaskResult withTasks(Task ... tasks) {
        if (this.getTasks() == null) {
            this.setTasks(new ArrayList<Task>(tasks.length));
        }
        for (Task value : tasks) {
            this.getTasks().add(value);
        }
        return this;
    }

    public RunTaskResult withTasks(Collection<Task> tasks) {
        if (tasks == null) {
            this.tasks = null;
        } else {
            ListWithAutoConstructFlag tasksCopy = new ListWithAutoConstructFlag(tasks.size());
            tasksCopy.addAll(tasks);
            this.tasks = tasksCopy;
        }
        return this;
    }

    public List<Failure> getFailures() {
        if (this.failures == null) {
            this.failures = new ListWithAutoConstructFlag();
            this.failures.setAutoConstruct(true);
        }
        return this.failures;
    }

    public void setFailures(Collection<Failure> failures) {
        if (failures == null) {
            this.failures = null;
            return;
        }
        ListWithAutoConstructFlag failuresCopy = new ListWithAutoConstructFlag(failures.size());
        failuresCopy.addAll(failures);
        this.failures = failuresCopy;
    }

    public RunTaskResult withFailures(Failure ... failures) {
        if (this.getFailures() == null) {
            this.setFailures(new ArrayList<Failure>(failures.length));
        }
        for (Failure value : failures) {
            this.getFailures().add(value);
        }
        return this;
    }

    public RunTaskResult withFailures(Collection<Failure> failures) {
        if (failures == null) {
            this.failures = null;
        } else {
            ListWithAutoConstructFlag failuresCopy = new ListWithAutoConstructFlag(failures.size());
            failuresCopy.addAll(failures);
            this.failures = failuresCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTasks() != null) {
            sb.append("Tasks: " + this.getTasks() + ",");
        }
        if (this.getFailures() != null) {
            sb.append("Failures: " + this.getFailures());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTasks() == null ? 0 : this.getTasks().hashCode());
        hashCode = 31 * hashCode + (this.getFailures() == null ? 0 : this.getFailures().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunTaskResult)) {
            return false;
        }
        RunTaskResult other = (RunTaskResult)obj;
        if (other.getTasks() == null ^ this.getTasks() == null) {
            return false;
        }
        if (other.getTasks() != null && !other.getTasks().equals(this.getTasks())) {
            return false;
        }
        if (other.getFailures() == null ^ this.getFailures() == null) {
            return false;
        }
        return other.getFailures() == null || other.getFailures().equals(this.getFailures());
    }
}

