/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticache.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddTagsToResourceResult
implements Serializable {
    private ListWithAutoConstructFlag<Tag> tagList;

    public List<Tag> getTagList() {
        if (this.tagList == null) {
            this.tagList = new ListWithAutoConstructFlag();
            this.tagList.setAutoConstruct(true);
        }
        return this.tagList;
    }

    public void setTagList(Collection<Tag> tagList) {
        if (tagList == null) {
            this.tagList = null;
            return;
        }
        ListWithAutoConstructFlag tagListCopy = new ListWithAutoConstructFlag(tagList.size());
        tagListCopy.addAll(tagList);
        this.tagList = tagListCopy;
    }

    public AddTagsToResourceResult withTagList(Tag ... tagList) {
        if (this.getTagList() == null) {
            this.setTagList(new ArrayList<Tag>(tagList.length));
        }
        for (Tag value : tagList) {
            this.getTagList().add(value);
        }
        return this;
    }

    public AddTagsToResourceResult withTagList(Collection<Tag> tagList) {
        if (tagList == null) {
            this.tagList = null;
        } else {
            ListWithAutoConstructFlag tagListCopy = new ListWithAutoConstructFlag(tagList.size());
            tagListCopy.addAll(tagList);
            this.tagList = tagListCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTagList() != null) {
            sb.append("TagList: " + this.getTagList());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTagList() == null ? 0 : this.getTagList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsToResourceResult)) {
            return false;
        }
        AddTagsToResourceResult other = (AddTagsToResourceResult)obj;
        if (other.getTagList() == null ^ this.getTagList() == null) {
            return false;
        }
        return other.getTagList() == null || other.getTagList().equals(this.getTagList());
    }
}

