/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.redshift.model.AccountWithRestoreAccess;
import com.amazonaws.services.redshift.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Snapshot
implements Serializable {
    private String snapshotIdentifier;
    private String clusterIdentifier;
    private Date snapshotCreateTime;
    private String status;
    private Integer port;
    private String availabilityZone;
    private Date clusterCreateTime;
    private String masterUsername;
    private String clusterVersion;
    private String snapshotType;
    private String nodeType;
    private Integer numberOfNodes;
    private String dBName;
    private String vpcId;
    private Boolean encrypted;
    private String kmsKeyId;
    private Boolean encryptedWithHSM;
    private ListWithAutoConstructFlag<AccountWithRestoreAccess> accountsWithRestoreAccess;
    private String ownerAccount;
    private Double totalBackupSizeInMegaBytes;
    private Double actualIncrementalBackupSizeInMegaBytes;
    private Double backupProgressInMegaBytes;
    private Double currentBackupRateInMegaBytesPerSecond;
    private Long estimatedSecondsToCompletion;
    private Long elapsedTimeInSeconds;
    private String sourceRegion;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getSnapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public void setSnapshotIdentifier(String snapshotIdentifier) {
        this.snapshotIdentifier = snapshotIdentifier;
    }

    public Snapshot withSnapshotIdentifier(String snapshotIdentifier) {
        this.snapshotIdentifier = snapshotIdentifier;
        return this;
    }

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public Snapshot withClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
        return this;
    }

    public Date getSnapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public void setSnapshotCreateTime(Date snapshotCreateTime) {
        this.snapshotCreateTime = snapshotCreateTime;
    }

    public Snapshot withSnapshotCreateTime(Date snapshotCreateTime) {
        this.snapshotCreateTime = snapshotCreateTime;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Snapshot withStatus(String status) {
        this.status = status;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Snapshot withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public Snapshot withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public Date getClusterCreateTime() {
        return this.clusterCreateTime;
    }

    public void setClusterCreateTime(Date clusterCreateTime) {
        this.clusterCreateTime = clusterCreateTime;
    }

    public Snapshot withClusterCreateTime(Date clusterCreateTime) {
        this.clusterCreateTime = clusterCreateTime;
        return this;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public Snapshot withMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
        return this;
    }

    public String getClusterVersion() {
        return this.clusterVersion;
    }

    public void setClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    public Snapshot withClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
        return this;
    }

    public String getSnapshotType() {
        return this.snapshotType;
    }

    public void setSnapshotType(String snapshotType) {
        this.snapshotType = snapshotType;
    }

    public Snapshot withSnapshotType(String snapshotType) {
        this.snapshotType = snapshotType;
        return this;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public Snapshot withNodeType(String nodeType) {
        this.nodeType = nodeType;
        return this;
    }

    public Integer getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public void setNumberOfNodes(Integer numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
    }

    public Snapshot withNumberOfNodes(Integer numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
        return this;
    }

    public String getDBName() {
        return this.dBName;
    }

    public void setDBName(String dBName) {
        this.dBName = dBName;
    }

    public Snapshot withDBName(String dBName) {
        this.dBName = dBName;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public Snapshot withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public Boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    public Snapshot withEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
        return this;
    }

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public Snapshot withKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
        return this;
    }

    public Boolean isEncryptedWithHSM() {
        return this.encryptedWithHSM;
    }

    public void setEncryptedWithHSM(Boolean encryptedWithHSM) {
        this.encryptedWithHSM = encryptedWithHSM;
    }

    public Snapshot withEncryptedWithHSM(Boolean encryptedWithHSM) {
        this.encryptedWithHSM = encryptedWithHSM;
        return this;
    }

    public Boolean getEncryptedWithHSM() {
        return this.encryptedWithHSM;
    }

    public List<AccountWithRestoreAccess> getAccountsWithRestoreAccess() {
        if (this.accountsWithRestoreAccess == null) {
            this.accountsWithRestoreAccess = new ListWithAutoConstructFlag();
            this.accountsWithRestoreAccess.setAutoConstruct(true);
        }
        return this.accountsWithRestoreAccess;
    }

    public void setAccountsWithRestoreAccess(Collection<AccountWithRestoreAccess> accountsWithRestoreAccess) {
        if (accountsWithRestoreAccess == null) {
            this.accountsWithRestoreAccess = null;
            return;
        }
        ListWithAutoConstructFlag accountsWithRestoreAccessCopy = new ListWithAutoConstructFlag(accountsWithRestoreAccess.size());
        accountsWithRestoreAccessCopy.addAll(accountsWithRestoreAccess);
        this.accountsWithRestoreAccess = accountsWithRestoreAccessCopy;
    }

    public Snapshot withAccountsWithRestoreAccess(AccountWithRestoreAccess ... accountsWithRestoreAccess) {
        if (this.getAccountsWithRestoreAccess() == null) {
            this.setAccountsWithRestoreAccess(new ArrayList<AccountWithRestoreAccess>(accountsWithRestoreAccess.length));
        }
        for (AccountWithRestoreAccess value : accountsWithRestoreAccess) {
            this.getAccountsWithRestoreAccess().add(value);
        }
        return this;
    }

    public Snapshot withAccountsWithRestoreAccess(Collection<AccountWithRestoreAccess> accountsWithRestoreAccess) {
        if (accountsWithRestoreAccess == null) {
            this.accountsWithRestoreAccess = null;
        } else {
            ListWithAutoConstructFlag accountsWithRestoreAccessCopy = new ListWithAutoConstructFlag(accountsWithRestoreAccess.size());
            accountsWithRestoreAccessCopy.addAll(accountsWithRestoreAccess);
            this.accountsWithRestoreAccess = accountsWithRestoreAccessCopy;
        }
        return this;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public void setOwnerAccount(String ownerAccount) {
        this.ownerAccount = ownerAccount;
    }

    public Snapshot withOwnerAccount(String ownerAccount) {
        this.ownerAccount = ownerAccount;
        return this;
    }

    public Double getTotalBackupSizeInMegaBytes() {
        return this.totalBackupSizeInMegaBytes;
    }

    public void setTotalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
        this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
    }

    public Snapshot withTotalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
        this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
        return this;
    }

    public Double getActualIncrementalBackupSizeInMegaBytes() {
        return this.actualIncrementalBackupSizeInMegaBytes;
    }

    public void setActualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
        this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
    }

    public Snapshot withActualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
        this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
        return this;
    }

    public Double getBackupProgressInMegaBytes() {
        return this.backupProgressInMegaBytes;
    }

    public void setBackupProgressInMegaBytes(Double backupProgressInMegaBytes) {
        this.backupProgressInMegaBytes = backupProgressInMegaBytes;
    }

    public Snapshot withBackupProgressInMegaBytes(Double backupProgressInMegaBytes) {
        this.backupProgressInMegaBytes = backupProgressInMegaBytes;
        return this;
    }

    public Double getCurrentBackupRateInMegaBytesPerSecond() {
        return this.currentBackupRateInMegaBytesPerSecond;
    }

    public void setCurrentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
        this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
    }

    public Snapshot withCurrentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
        this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
        return this;
    }

    public Long getEstimatedSecondsToCompletion() {
        return this.estimatedSecondsToCompletion;
    }

    public void setEstimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
        this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
    }

    public Snapshot withEstimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
        this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
        return this;
    }

    public Long getElapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds;
    }

    public void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
        this.elapsedTimeInSeconds = elapsedTimeInSeconds;
    }

    public Snapshot withElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
        this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        return this;
    }

    public String getSourceRegion() {
        return this.sourceRegion;
    }

    public void setSourceRegion(String sourceRegion) {
        this.sourceRegion = sourceRegion;
    }

    public Snapshot withSourceRegion(String sourceRegion) {
        this.sourceRegion = sourceRegion;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public Snapshot withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public Snapshot withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSnapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: " + this.getSnapshotIdentifier() + ",");
        }
        if (this.getClusterIdentifier() != null) {
            sb.append("ClusterIdentifier: " + this.getClusterIdentifier() + ",");
        }
        if (this.getSnapshotCreateTime() != null) {
            sb.append("SnapshotCreateTime: " + this.getSnapshotCreateTime() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getPort() != null) {
            sb.append("Port: " + this.getPort() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getClusterCreateTime() != null) {
            sb.append("ClusterCreateTime: " + this.getClusterCreateTime() + ",");
        }
        if (this.getMasterUsername() != null) {
            sb.append("MasterUsername: " + this.getMasterUsername() + ",");
        }
        if (this.getClusterVersion() != null) {
            sb.append("ClusterVersion: " + this.getClusterVersion() + ",");
        }
        if (this.getSnapshotType() != null) {
            sb.append("SnapshotType: " + this.getSnapshotType() + ",");
        }
        if (this.getNodeType() != null) {
            sb.append("NodeType: " + this.getNodeType() + ",");
        }
        if (this.getNumberOfNodes() != null) {
            sb.append("NumberOfNodes: " + this.getNumberOfNodes() + ",");
        }
        if (this.getDBName() != null) {
            sb.append("DBName: " + this.getDBName() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.isEncrypted() != null) {
            sb.append("Encrypted: " + this.isEncrypted() + ",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: " + this.getKmsKeyId() + ",");
        }
        if (this.isEncryptedWithHSM() != null) {
            sb.append("EncryptedWithHSM: " + this.isEncryptedWithHSM() + ",");
        }
        if (this.getAccountsWithRestoreAccess() != null) {
            sb.append("AccountsWithRestoreAccess: " + this.getAccountsWithRestoreAccess() + ",");
        }
        if (this.getOwnerAccount() != null) {
            sb.append("OwnerAccount: " + this.getOwnerAccount() + ",");
        }
        if (this.getTotalBackupSizeInMegaBytes() != null) {
            sb.append("TotalBackupSizeInMegaBytes: " + this.getTotalBackupSizeInMegaBytes() + ",");
        }
        if (this.getActualIncrementalBackupSizeInMegaBytes() != null) {
            sb.append("ActualIncrementalBackupSizeInMegaBytes: " + this.getActualIncrementalBackupSizeInMegaBytes() + ",");
        }
        if (this.getBackupProgressInMegaBytes() != null) {
            sb.append("BackupProgressInMegaBytes: " + this.getBackupProgressInMegaBytes() + ",");
        }
        if (this.getCurrentBackupRateInMegaBytesPerSecond() != null) {
            sb.append("CurrentBackupRateInMegaBytesPerSecond: " + this.getCurrentBackupRateInMegaBytesPerSecond() + ",");
        }
        if (this.getEstimatedSecondsToCompletion() != null) {
            sb.append("EstimatedSecondsToCompletion: " + this.getEstimatedSecondsToCompletion() + ",");
        }
        if (this.getElapsedTimeInSeconds() != null) {
            sb.append("ElapsedTimeInSeconds: " + this.getElapsedTimeInSeconds() + ",");
        }
        if (this.getSourceRegion() != null) {
            sb.append("SourceRegion: " + this.getSourceRegion() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSnapshotIdentifier() == null ? 0 : this.getSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getClusterIdentifier() == null ? 0 : this.getClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotCreateTime() == null ? 0 : this.getSnapshotCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getClusterCreateTime() == null ? 0 : this.getClusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUsername() == null ? 0 : this.getMasterUsername().hashCode());
        hashCode = 31 * hashCode + (this.getClusterVersion() == null ? 0 : this.getClusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotType() == null ? 0 : this.getSnapshotType().hashCode());
        hashCode = 31 * hashCode + (this.getNodeType() == null ? 0 : this.getNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfNodes() == null ? 0 : this.getNumberOfNodes().hashCode());
        hashCode = 31 * hashCode + (this.getDBName() == null ? 0 : this.getDBName().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.isEncrypted() == null ? 0 : this.isEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.isEncryptedWithHSM() == null ? 0 : this.isEncryptedWithHSM().hashCode());
        hashCode = 31 * hashCode + (this.getAccountsWithRestoreAccess() == null ? 0 : this.getAccountsWithRestoreAccess().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerAccount() == null ? 0 : this.getOwnerAccount().hashCode());
        hashCode = 31 * hashCode + (this.getTotalBackupSizeInMegaBytes() == null ? 0 : this.getTotalBackupSizeInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.getActualIncrementalBackupSizeInMegaBytes() == null ? 0 : this.getActualIncrementalBackupSizeInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.getBackupProgressInMegaBytes() == null ? 0 : this.getBackupProgressInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentBackupRateInMegaBytesPerSecond() == null ? 0 : this.getCurrentBackupRateInMegaBytesPerSecond().hashCode());
        hashCode = 31 * hashCode + (this.getEstimatedSecondsToCompletion() == null ? 0 : this.getEstimatedSecondsToCompletion().hashCode());
        hashCode = 31 * hashCode + (this.getElapsedTimeInSeconds() == null ? 0 : this.getElapsedTimeInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getSourceRegion() == null ? 0 : this.getSourceRegion().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        if (other.getSnapshotIdentifier() == null ^ this.getSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getSnapshotIdentifier() != null && !other.getSnapshotIdentifier().equals(this.getSnapshotIdentifier())) {
            return false;
        }
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null) {
            return false;
        }
        if (other.getClusterIdentifier() != null && !other.getClusterIdentifier().equals(this.getClusterIdentifier())) {
            return false;
        }
        if (other.getSnapshotCreateTime() == null ^ this.getSnapshotCreateTime() == null) {
            return false;
        }
        if (other.getSnapshotCreateTime() != null && !other.getSnapshotCreateTime().equals(this.getSnapshotCreateTime())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getClusterCreateTime() == null ^ this.getClusterCreateTime() == null) {
            return false;
        }
        if (other.getClusterCreateTime() != null && !other.getClusterCreateTime().equals(this.getClusterCreateTime())) {
            return false;
        }
        if (other.getMasterUsername() == null ^ this.getMasterUsername() == null) {
            return false;
        }
        if (other.getMasterUsername() != null && !other.getMasterUsername().equals(this.getMasterUsername())) {
            return false;
        }
        if (other.getClusterVersion() == null ^ this.getClusterVersion() == null) {
            return false;
        }
        if (other.getClusterVersion() != null && !other.getClusterVersion().equals(this.getClusterVersion())) {
            return false;
        }
        if (other.getSnapshotType() == null ^ this.getSnapshotType() == null) {
            return false;
        }
        if (other.getSnapshotType() != null && !other.getSnapshotType().equals(this.getSnapshotType())) {
            return false;
        }
        if (other.getNodeType() == null ^ this.getNodeType() == null) {
            return false;
        }
        if (other.getNodeType() != null && !other.getNodeType().equals(this.getNodeType())) {
            return false;
        }
        if (other.getNumberOfNodes() == null ^ this.getNumberOfNodes() == null) {
            return false;
        }
        if (other.getNumberOfNodes() != null && !other.getNumberOfNodes().equals(this.getNumberOfNodes())) {
            return false;
        }
        if (other.getDBName() == null ^ this.getDBName() == null) {
            return false;
        }
        if (other.getDBName() != null && !other.getDBName().equals(this.getDBName())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.isEncrypted() == null ^ this.isEncrypted() == null) {
            return false;
        }
        if (other.isEncrypted() != null && !other.isEncrypted().equals(this.isEncrypted())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.isEncryptedWithHSM() == null ^ this.isEncryptedWithHSM() == null) {
            return false;
        }
        if (other.isEncryptedWithHSM() != null && !other.isEncryptedWithHSM().equals(this.isEncryptedWithHSM())) {
            return false;
        }
        if (other.getAccountsWithRestoreAccess() == null ^ this.getAccountsWithRestoreAccess() == null) {
            return false;
        }
        if (other.getAccountsWithRestoreAccess() != null && !other.getAccountsWithRestoreAccess().equals(this.getAccountsWithRestoreAccess())) {
            return false;
        }
        if (other.getOwnerAccount() == null ^ this.getOwnerAccount() == null) {
            return false;
        }
        if (other.getOwnerAccount() != null && !other.getOwnerAccount().equals(this.getOwnerAccount())) {
            return false;
        }
        if (other.getTotalBackupSizeInMegaBytes() == null ^ this.getTotalBackupSizeInMegaBytes() == null) {
            return false;
        }
        if (other.getTotalBackupSizeInMegaBytes() != null && !other.getTotalBackupSizeInMegaBytes().equals(this.getTotalBackupSizeInMegaBytes())) {
            return false;
        }
        if (other.getActualIncrementalBackupSizeInMegaBytes() == null ^ this.getActualIncrementalBackupSizeInMegaBytes() == null) {
            return false;
        }
        if (other.getActualIncrementalBackupSizeInMegaBytes() != null && !other.getActualIncrementalBackupSizeInMegaBytes().equals(this.getActualIncrementalBackupSizeInMegaBytes())) {
            return false;
        }
        if (other.getBackupProgressInMegaBytes() == null ^ this.getBackupProgressInMegaBytes() == null) {
            return false;
        }
        if (other.getBackupProgressInMegaBytes() != null && !other.getBackupProgressInMegaBytes().equals(this.getBackupProgressInMegaBytes())) {
            return false;
        }
        if (other.getCurrentBackupRateInMegaBytesPerSecond() == null ^ this.getCurrentBackupRateInMegaBytesPerSecond() == null) {
            return false;
        }
        if (other.getCurrentBackupRateInMegaBytesPerSecond() != null && !other.getCurrentBackupRateInMegaBytesPerSecond().equals(this.getCurrentBackupRateInMegaBytesPerSecond())) {
            return false;
        }
        if (other.getEstimatedSecondsToCompletion() == null ^ this.getEstimatedSecondsToCompletion() == null) {
            return false;
        }
        if (other.getEstimatedSecondsToCompletion() != null && !other.getEstimatedSecondsToCompletion().equals(this.getEstimatedSecondsToCompletion())) {
            return false;
        }
        if (other.getElapsedTimeInSeconds() == null ^ this.getElapsedTimeInSeconds() == null) {
            return false;
        }
        if (other.getElapsedTimeInSeconds() != null && !other.getElapsedTimeInSeconds().equals(this.getElapsedTimeInSeconds())) {
            return false;
        }
        if (other.getSourceRegion() == null ^ this.getSourceRegion() == null) {
            return false;
        }
        if (other.getSourceRegion() != null && !other.getSourceRegion().equals(this.getSourceRegion())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }
}

