/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53.model.DelegationSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListReusableDelegationSetsResult
implements Serializable {
    private ListWithAutoConstructFlag<DelegationSet> delegationSets;
    private String marker;
    private Boolean isTruncated;
    private String nextMarker;
    private String maxItems;

    public List<DelegationSet> getDelegationSets() {
        if (this.delegationSets == null) {
            this.delegationSets = new ListWithAutoConstructFlag();
            this.delegationSets.setAutoConstruct(true);
        }
        return this.delegationSets;
    }

    public void setDelegationSets(Collection<DelegationSet> delegationSets) {
        if (delegationSets == null) {
            this.delegationSets = null;
            return;
        }
        ListWithAutoConstructFlag delegationSetsCopy = new ListWithAutoConstructFlag(delegationSets.size());
        delegationSetsCopy.addAll(delegationSets);
        this.delegationSets = delegationSetsCopy;
    }

    public ListReusableDelegationSetsResult withDelegationSets(DelegationSet ... delegationSets) {
        if (this.getDelegationSets() == null) {
            this.setDelegationSets(new ArrayList<DelegationSet>(delegationSets.length));
        }
        for (DelegationSet value : delegationSets) {
            this.getDelegationSets().add(value);
        }
        return this;
    }

    public ListReusableDelegationSetsResult withDelegationSets(Collection<DelegationSet> delegationSets) {
        if (delegationSets == null) {
            this.delegationSets = null;
        } else {
            ListWithAutoConstructFlag delegationSetsCopy = new ListWithAutoConstructFlag(delegationSets.size());
            delegationSetsCopy.addAll(delegationSets);
            this.delegationSets = delegationSetsCopy;
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListReusableDelegationSetsResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public ListReusableDelegationSetsResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public ListReusableDelegationSetsResult withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public String getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(String maxItems) {
        this.maxItems = maxItems;
    }

    public ListReusableDelegationSetsResult withMaxItems(String maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDelegationSets() != null) {
            sb.append("DelegationSets: " + this.getDelegationSets() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated() + ",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker() + ",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: " + this.getMaxItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDelegationSets() == null ? 0 : this.getDelegationSets().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReusableDelegationSetsResult)) {
            return false;
        }
        ListReusableDelegationSetsResult other = (ListReusableDelegationSetsResult)obj;
        if (other.getDelegationSets() == null ^ this.getDelegationSets() == null) {
            return false;
        }
        if (other.getDelegationSets() != null && !other.getDelegationSets().equals(this.getDelegationSets())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        return other.getMaxItems() == null || other.getMaxItems().equals(this.getMaxItems());
    }
}

