/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationBatchRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationBatchResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.GetDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsResult;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateAssociationStatusRequest;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateAssociationStatusResult;
import com.amazonaws.services.simplesystemsmanagement.model.transform.AssociatedInstancesExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.AssociationAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.AssociationDoesNotExistExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.AssociationLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationBatchRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationBatchResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateDocumentRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateDocumentResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DeleteAssociationRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DeleteAssociationResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DeleteDocumentRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DeleteDocumentResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeAssociationRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeAssociationResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeDocumentRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeDocumentResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DocumentAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DocumentLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DuplicateInstanceIdExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.GetDocumentRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.GetDocumentResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InvalidDocumentContentExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InvalidDocumentExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InvalidInstanceIdExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListAssociationsRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListAssociationsResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListDocumentsRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListDocumentsResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.MaxDocumentSizeExceededExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.StatusUnchangedExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.TooManyUpdatesExceptionUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.UpdateAssociationStatusRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.UpdateAssociationStatusResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSSimpleSystemsManagementClient
extends AmazonWebServiceClient
implements AWSSimpleSystemsManagement {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSimpleSystemsManagement.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AWSSimpleSystemsManagementClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSSimpleSystemsManagementClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSSimpleSystemsManagementClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSSimpleSystemsManagementClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AWSSimpleSystemsManagementClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSSimpleSystemsManagementClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSSimpleSystemsManagementClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSSimpleSystemsManagementClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AWSSimpleSystemsManagementClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new AssociatedInstancesExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new DocumentLimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new DocumentAlreadyExistsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new MaxDocumentSizeExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new AssociationAlreadyExistsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TooManyUpdatesExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new AssociationLimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InternalServerErrorExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidDocumentContentExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new AssociationDoesNotExistExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new DuplicateInstanceIdExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidInstanceIdExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidDocumentExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new StatusUnchangedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("ssm.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simplesystemsmanagement/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/simplesystemsmanagement/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDocumentResult deleteDocument(DeleteDocumentRequest deleteDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDocumentRequestMarshaller().marshall(deleteDocumentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteDocumentResultJsonUnmarshaller unmarshaller = new DeleteDocumentResultJsonUnmarshaller();
            JsonResponseHandler<DeleteDocumentResult> responseHandler = new JsonResponseHandler<DeleteDocumentResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDocumentResult deleteDocumentResult = (DeleteDocumentResult)response.getAwsResponse();
            return deleteDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssociationResult describeAssociation(DescribeAssociationRequest describeAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAssociationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAssociationRequestMarshaller().marshall(describeAssociationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeAssociationResultJsonUnmarshaller unmarshaller = new DescribeAssociationResultJsonUnmarshaller();
            JsonResponseHandler<DescribeAssociationResult> responseHandler = new JsonResponseHandler<DescribeAssociationResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAssociationResult describeAssociationResult = (DescribeAssociationResult)response.getAwsResponse();
            return describeAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssociationResult createAssociation(CreateAssociationRequest createAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAssociationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAssociationRequestMarshaller().marshall(createAssociationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateAssociationResultJsonUnmarshaller unmarshaller = new CreateAssociationResultJsonUnmarshaller();
            JsonResponseHandler<CreateAssociationResult> responseHandler = new JsonResponseHandler<CreateAssociationResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateAssociationResult createAssociationResult = (CreateAssociationResult)response.getAwsResponse();
            return createAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssociationBatchResult createAssociationBatch(CreateAssociationBatchRequest createAssociationBatchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAssociationBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAssociationBatchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAssociationBatchRequestMarshaller().marshall(createAssociationBatchRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateAssociationBatchResultJsonUnmarshaller unmarshaller = new CreateAssociationBatchResultJsonUnmarshaller();
            JsonResponseHandler<CreateAssociationBatchResult> responseHandler = new JsonResponseHandler<CreateAssociationBatchResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateAssociationBatchResult createAssociationBatchResult = (CreateAssociationBatchResult)response.getAwsResponse();
            return createAssociationBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDocumentResult describeDocument(DescribeDocumentRequest describeDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDocumentRequestMarshaller().marshall(describeDocumentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeDocumentResultJsonUnmarshaller unmarshaller = new DescribeDocumentResultJsonUnmarshaller();
            JsonResponseHandler<DescribeDocumentResult> responseHandler = new JsonResponseHandler<DescribeDocumentResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDocumentResult describeDocumentResult = (DescribeDocumentResult)response.getAwsResponse();
            return describeDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAssociationStatusResult updateAssociationStatus(UpdateAssociationStatusRequest updateAssociationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAssociationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAssociationStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAssociationStatusRequestMarshaller().marshall(updateAssociationStatusRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateAssociationStatusResultJsonUnmarshaller unmarshaller = new UpdateAssociationStatusResultJsonUnmarshaller();
            JsonResponseHandler<UpdateAssociationStatusResult> responseHandler = new JsonResponseHandler<UpdateAssociationStatusResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAssociationStatusResult updateAssociationStatusResult = (UpdateAssociationStatusResult)response.getAwsResponse();
            return updateAssociationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssociationsResult listAssociations(ListAssociationsRequest listAssociationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssociationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssociationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssociationsRequestMarshaller().marshall(listAssociationsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListAssociationsResultJsonUnmarshaller unmarshaller = new ListAssociationsResultJsonUnmarshaller();
            JsonResponseHandler<ListAssociationsResult> responseHandler = new JsonResponseHandler<ListAssociationsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListAssociationsResult listAssociationsResult = (ListAssociationsResult)response.getAwsResponse();
            return listAssociationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDocumentsResult listDocuments(ListDocumentsRequest listDocumentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDocumentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDocumentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDocumentsRequestMarshaller().marshall(listDocumentsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListDocumentsResultJsonUnmarshaller unmarshaller = new ListDocumentsResultJsonUnmarshaller();
            JsonResponseHandler<ListDocumentsResult> responseHandler = new JsonResponseHandler<ListDocumentsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListDocumentsResult listDocumentsResult = (ListDocumentsResult)response.getAwsResponse();
            return listDocumentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssociationResult deleteAssociation(DeleteAssociationRequest deleteAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAssociationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAssociationRequestMarshaller().marshall(deleteAssociationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteAssociationResultJsonUnmarshaller unmarshaller = new DeleteAssociationResultJsonUnmarshaller();
            JsonResponseHandler<DeleteAssociationResult> responseHandler = new JsonResponseHandler<DeleteAssociationResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAssociationResult deleteAssociationResult = (DeleteAssociationResult)response.getAwsResponse();
            return deleteAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDocumentResult createDocument(CreateDocumentRequest createDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDocumentRequestMarshaller().marshall(createDocumentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateDocumentResultJsonUnmarshaller unmarshaller = new CreateDocumentResultJsonUnmarshaller();
            JsonResponseHandler<CreateDocumentResult> responseHandler = new JsonResponseHandler<CreateDocumentResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateDocumentResult createDocumentResult = (CreateDocumentResult)response.getAwsResponse();
            return createDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDocumentResult getDocument(GetDocumentRequest getDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDocumentRequestMarshaller().marshall(getDocumentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetDocumentResultJsonUnmarshaller unmarshaller = new GetDocumentResultJsonUnmarshaller();
            JsonResponseHandler<GetDocumentResult> responseHandler = new JsonResponseHandler<GetDocumentResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetDocumentResult getDocumentResult = (GetDocumentResult)response.getAwsResponse();
            return getDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public ListDocumentsResult listDocuments() throws AmazonServiceException, AmazonClientException {
        return this.listDocuments(new ListDocumentsRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        return result;
    }
}

