/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util;

import java.util.Set;
import org.duracloud.account.compute.error.DuracloudInstanceNotAvailableException;
import org.duracloud.account.db.model.DuracloudInstance;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.InstanceType;
import org.springframework.security.access.annotation.Secured;

public interface DuracloudInstanceService {
    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public Long getAccountId();

    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public DuracloudInstance getInstanceInfo();

    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public String getInstanceVersion();

    @Secured(value={"role:ROLE_USER, scope:SELF_ACCT"})
    public String getStatus() throws DuracloudInstanceNotAvailableException;

    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public InstanceType getInstanceType() throws DuracloudInstanceNotAvailableException;

    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public String getStatusInternal() throws DuracloudInstanceNotAvailableException;

    @Secured(value={"role:ROLE_ROOT, scope:SELF_ACCT"})
    public void stop();

    @Secured(value={"role:ROLE_ROOT, scope:SELF_ACCT"})
    public void restart();

    @Secured(value={"role:ROLE_ROOT, scope:SELF_ACCT"})
    public void initialize();

    @Secured(value={"role:ROLE_ROOT, scope:ANY"})
    public void reInitializeUserRoles();

    @Secured(value={"role:ROLE_ROOT, scope:ANY"})
    public void reInitialize();

    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public void setUserRoles(Set<DuracloudUser> var1);
}

