/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.duracloud.account.config.AmaEndpoint;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.AccountRights;
import org.duracloud.account.db.model.ComputeProviderAccount;
import org.duracloud.account.db.model.DuracloudGroup;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.ServerDetails;
import org.duracloud.account.db.model.ServerImage;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.account.db.repo.DuracloudGroupRepo;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.repo.DuracloudRightsRepo;
import org.duracloud.account.db.repo.DuracloudServerImageRepo;
import org.duracloud.account.db.repo.DuracloudStorageProviderAccountRepo;
import org.duracloud.account.db.repo.DuracloudUserInvitationRepo;
import org.duracloud.account.db.repo.DuracloudUserRepo;
import org.duracloud.account.db.util.DuracloudInstanceManagerService;
import org.duracloud.account.db.util.DuracloudInstanceService;
import org.duracloud.account.db.util.DuracloudUserService;
import org.duracloud.account.db.util.RootAccountManagerService;
import org.duracloud.account.db.util.error.DBNotFoundException;
import org.duracloud.account.db.util.error.InvalidPasswordException;
import org.duracloud.account.db.util.error.UnsentEmailException;
import org.duracloud.account.db.util.notification.NotificationMgr;
import org.duracloud.account.db.util.notification.Notifier;
import org.duracloud.account.db.util.usermgmt.UserDetailsPropagator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;

public class RootAccountManagerServiceImpl
implements RootAccountManagerService {
    private Logger log = LoggerFactory.getLogger(RootAccountManagerServiceImpl.class);
    private DuracloudRepoMgr repoMgr;
    private UserDetailsPropagator propagator;
    private NotificationMgr notificationMgr;
    private Notifier notifier;
    private DuracloudInstanceManagerService instanceManagerService;
    private DuracloudUserService userService;
    private AmaEndpoint amaEndpoint;

    public RootAccountManagerServiceImpl(DuracloudRepoMgr duracloudRepoMgr, NotificationMgr notificationMgr, UserDetailsPropagator propagator, DuracloudInstanceManagerService instanceManagerService, DuracloudUserService userService, AmaEndpoint amaEndpoint) {
        this.repoMgr = duracloudRepoMgr;
        this.notificationMgr = notificationMgr;
        this.propagator = propagator;
        this.instanceManagerService = instanceManagerService;
        this.userService = userService;
        this.amaEndpoint = amaEndpoint;
    }

    @Override
    public void addDuracloudImage(String imageId, String version, String description) {
        throw new NotImplementedException("addDuracloudImage not implemented");
    }

    @Override
    public void resetUsersPassword(Long userId) throws DBNotFoundException, UnsentEmailException {
        this.log.info("Resetting password for user with ID {}", (Object)userId);
        DuracloudUser user = (DuracloudUser)this.getUserRepo().findOne(userId);
        if (user == null) {
            throw new DBNotFoundException("User with ID: " + userId + " does not exist");
        }
        try {
            this.userService.forgotPassword(user.getUsername(), user.getSecurityQuestion(), user.getSecurityAnswer());
        }
        catch (InvalidPasswordException e) {
            this.log.error("This should never happen!", e);
        }
    }

    @Override
    public void deleteUser(Long userId) {
        this.log.info("Deleting user with ID {}", (Object)userId);
        List<AccountRights> accountRights = this.getRightsRepo().findByUserId(userId);
        for (AccountRights right : accountRights) {
            this.userService.revokeUserRights(right.getAccount().getId(), userId);
        }
        DuracloudUser user = (DuracloudUser)this.repoMgr.getUserRepo().findOne(userId);
        DuracloudGroupRepo groupRepo = this.getGroupRepo();
        List allGroups = groupRepo.findAll();
        for (DuracloudGroup group : allGroups) {
            Set<DuracloudUser> groupUsers = group.getUsers();
            if (!groupUsers.contains(user)) continue;
            groupUsers.remove(user);
            groupRepo.save(group);
        }
        this.getUserRepo().delete(userId);
    }

    @Override
    public void deleteAccount(Long accountId) {
        this.log.info("Deleting account with ID {}", (Object)accountId);
        AccountInfo account = this.getAccount(accountId);
        Set<DuracloudInstanceService> instanceServices = this.instanceManagerService.getInstanceServices(accountId);
        if (instanceServices.size() > 0) {
            this.log.error("Unable to delete account {} found an instance", (Object)accountId);
            return;
        }
        List<AccountRights> rightsList = this.getRightsRepo().findByAccountId(accountId);
        for (AccountRights rights : rightsList) {
            DuracloudUser user = rights.getUser();
            user.getAccountRights().remove(rights);
            rights.getRoles().clear();
            this.getRightsRepo().save(rights);
        }
        this.getRightsRepo().deleteInBatch(rightsList);
        DuracloudGroupRepo groupRepo = this.repoMgr.getGroupRepo();
        List<DuracloudGroup> groups = groupRepo.findByAccountId(accountId);
        groupRepo.deleteInBatch(groups);
        DuracloudUserInvitationRepo invRepo = this.repoMgr.getUserInvitationRepo();
        invRepo.deleteInBatch(invRepo.findByAccountId(accountId));
        this.getAccountRepo().delete(accountId);
    }

    @Override
    public List<StorageProviderAccount> getSecondaryStorageProviders(Long accountId) {
        AccountInfo account = (AccountInfo)this.repoMgr.getAccountRepo().findOne(accountId);
        ServerDetails serverDetails = account.getServerDetails();
        return new ArrayList<StorageProviderAccount>(serverDetails.getSecondaryStorageProviderAccounts());
    }

    @Override
    public void setupStorageProvider(Long providerId, String username, String password, Map<String, String> properties, int storageLimit) {
        this.log.info("Setting up storage provider with ID {}", (Object)providerId);
        StorageProviderAccount storageProviderAccount = (StorageProviderAccount)this.getStorageRepo().findOne(providerId);
        storageProviderAccount.setUsername(username);
        storageProviderAccount.setPassword(password);
        storageProviderAccount.getProperties().putAll(properties);
        storageProviderAccount.setStorageLimit(storageLimit);
        this.getStorageRepo().save(storageProviderAccount);
    }

    @Override
    public void setupComputeProvider(Long providerId, String username, String password, String elasticIp, String keypair, String securityGroup) {
        this.log.info("Setting up compute provider with ID {}", (Object)providerId);
        ComputeProviderAccount computeProviderAcct = (ComputeProviderAccount)this.repoMgr.getComputeProviderAccountRepo().findOne(providerId);
        computeProviderAcct.setUsername(username);
        computeProviderAcct.setPassword(password);
        computeProviderAcct.setElasticIp(elasticIp);
        computeProviderAcct.setKeypair(keypair);
        computeProviderAcct.setSecurityGroup(securityGroup);
        this.repoMgr.getComputeProviderAccountRepo().save(computeProviderAcct);
    }

    @Override
    public AccountInfo getAccount(Long id) {
        return (AccountInfo)this.getAccountRepo().findOne(id);
    }

    @Override
    public void activateAccount(Long accountId) {
        this.log.info("Activating account with ID {}", (Object)accountId);
        AccountInfo accountInfo = (AccountInfo)this.getAccountRepo().findOne(accountId);
        accountInfo.setStatus(AccountInfo.AccountStatus.ACTIVE);
        this.getAccountRepo().save(accountInfo);
    }

    @Override
    public Set<AccountInfo> listAllAccounts(String filter) {
        List accounts = this.getAccountRepo().findAll(new Sort("acctName"));
        LinkedHashSet<AccountInfo> accountInfos = new LinkedHashSet<AccountInfo>();
        for (AccountInfo acct : accounts) {
            if (filter != null && !acct.getOrgName().startsWith(filter)) continue;
            accountInfos.add(acct);
        }
        return accountInfos;
    }

    @Override
    public Set<DuracloudUser> listAllUsers(String filter) {
        List usersList = this.getUserRepo().findAll(new Sort("username"));
        LinkedHashSet<DuracloudUser> users = new LinkedHashSet<DuracloudUser>();
        for (DuracloudUser user : usersList) {
            if (filter != null && !user.getUsername().startsWith(filter) && !user.getFirstName().startsWith(filter) && !user.getLastName().startsWith(filter) && !user.getEmail().startsWith(filter)) continue;
            users.add(user);
        }
        return users;
    }

    @Override
    public Set<ServerImage> listAllServerImages(String filter) {
        List imageList = this.getServerImageRepo().findAll(new Sort(Sort.Direction.DESC, "version"));
        LinkedHashSet<ServerImage> images = new LinkedHashSet<ServerImage>();
        for (ServerImage image : imageList) {
            if (filter != null && !image.getProviderImageId().startsWith(filter)) continue;
            images.add(image);
        }
        return images;
    }

    @Override
    public void createServerImage(String providerImageId, String version, String description, String password, boolean latest, String iamRole, String cfKeyPath, String cfAccountId, String cfKeyId) {
        Long imageCount;
        DuracloudServerImageRepo imageRepo = this.getServerImageRepo();
        if (latest) {
            ServerImage latestImage = imageRepo.findLatest();
            latestImage.setLatest(!latest);
            imageRepo.save(latestImage);
        }
        if ((imageCount = Long.valueOf(imageRepo.count())) == 0L) {
            latest = true;
        }
        ServerImage serverImage = new ServerImage();
        serverImage.setProviderImageId(providerImageId);
        serverImage.setVersion(version);
        serverImage.setDescription(description);
        serverImage.setDcRootPassword(password);
        serverImage.setLatest(latest);
        serverImage.setIamRole(iamRole);
        serverImage.setCfKeyPath(cfKeyPath);
        serverImage.setCfAccountId(cfAccountId);
        serverImage.setCfKeyId(cfKeyId);
        this.getServerImageRepo().save(serverImage);
    }

    @Override
    public void editServerImage(Long id, String providerImageId, String version, String description, String password, boolean latest, String iamRole, String cfKeyPath, String cfAccountId, String cfKeyId) {
        ServerImage serverImage = (ServerImage)this.getServerImageRepo().findOne(id);
        ServerImage latestImage = this.getServerImageRepo().findLatest();
        if (!latestImage.getId().equals(id)) {
            if (latest) {
                latestImage.setLatest(false);
                this.getServerImageRepo().save(latestImage);
            }
            serverImage.setLatest(latest);
        }
        serverImage.setProviderImageId(providerImageId);
        serverImage.setVersion(version);
        serverImage.setDescription(description);
        serverImage.setDcRootPassword(password);
        serverImage.setIamRole(iamRole);
        serverImage.setCfKeyPath(cfKeyPath);
        serverImage.setCfAccountId(cfAccountId);
        serverImage.setCfKeyId(cfKeyId);
        this.getServerImageRepo().save(serverImage);
    }

    @Override
    public ServerImage getServerImage(Long id) {
        return (ServerImage)this.getServerImageRepo().findOne(id);
    }

    @Override
    public void deleteServerImage(Long id) {
        this.log.info("Deleting server image with ID {}", (Object)id);
        this.getServerImageRepo().delete(id);
    }

    private DuracloudServerImageRepo getServerImageRepo() {
        return this.repoMgr.getServerImageRepo();
    }

    private DuracloudUserRepo getUserRepo() {
        return this.repoMgr.getUserRepo();
    }

    private DuracloudGroupRepo getGroupRepo() {
        return this.repoMgr.getGroupRepo();
    }

    private DuracloudAccountRepo getAccountRepo() {
        return this.repoMgr.getAccountRepo();
    }

    private DuracloudRightsRepo getRightsRepo() {
        return this.repoMgr.getRightsRepo();
    }

    private DuracloudStorageProviderAccountRepo getStorageRepo() {
        return this.repoMgr.getStorageProviderAccountRepo();
    }

    private Notifier getNotifier() {
        if (null == this.notifier) {
            this.notifier = new Notifier(this.notificationMgr.getEmailer(), this.amaEndpoint);
        }
        return this.notifier;
    }
}

