/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.instance.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.duracloud.account.db.util.error.DuracloudInstanceUpdateException;
import org.duracloud.account.db.util.instance.InstanceUpdater;
import org.duracloud.account.db.util.instance.InstanceUtil;
import org.duracloud.appconfig.domain.Application;
import org.duracloud.appconfig.domain.DurabossConfig;
import org.duracloud.appconfig.domain.DuradminConfig;
import org.duracloud.appconfig.domain.DurastoreConfig;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.security.domain.SecurityUserBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceUpdaterImpl
implements InstanceUpdater,
InstanceUtil {
    private Logger log = LoggerFactory.getLogger(InstanceUpdaterImpl.class);
    private static final String port = "443";

    @Override
    public void initializeInstance(String host, DuradminConfig duradminConfig, DurastoreConfig durastoreConfig, DurabossConfig durabossConfig, RestHttpHelper restHelper) {
        this.log.info("Initializing DuraCloud applications at host {}", (Object)host);
        if (StringUtils.isBlank(host) || null == duradminConfig || null == durastoreConfig || null == durabossConfig || null == restHelper) {
            StringBuilder msg = new StringBuilder("Invalid arguments: ");
            msg.append(host + ", ");
            msg.append(duradminConfig + ", ");
            msg.append(durastoreConfig + ", ");
            msg.append(durabossConfig + ", ");
            msg.append(restHelper);
            throw new DuracloudInstanceUpdateException(msg.toString());
        }
        Application durastoreApp = this.getDurastoreApplication(host, restHelper);
        this.checkResponse("DuraStore", durastoreApp.initialize(durastoreConfig));
        Application durabossApp = this.getDurabossApplication(host, restHelper);
        this.checkResponse("DuraBoss", durabossApp.initialize(durabossConfig));
        Application duradminApp = this.getDuradminApplication(host, restHelper);
        this.checkResponse("DurAdmin", duradminApp.initialize(duradminConfig));
    }

    @Override
    public void updateUserDetails(String host, Set<SecurityUserBean> userBeans, RestHttpHelper restHelper) {
        this.log.info("Updating user details at DuraCloud host {}", (Object)host);
        if (StringUtils.isBlank(host) || null == userBeans || null == restHelper) {
            StringBuilder msg = new StringBuilder("Invalid arguments: ");
            msg.append(host + ", ");
            msg.append(userBeans + ", ");
            msg.append(restHelper);
            throw new DuracloudInstanceUpdateException(msg.toString());
        }
        for (Application app : this.getApplications(host, restHelper)) {
            app.setSecurityUsers(userBeans);
        }
    }

    private List<Application> getApplications(String host, RestHttpHelper restHelper) {
        ArrayList<Application> apps = new ArrayList<Application>();
        apps.add(this.getDuradminApplication(host, restHelper));
        apps.add(this.getDurastoreApplication(host, restHelper));
        apps.add(this.getDurabossApplication(host, restHelper));
        return apps;
    }

    private Application getDuradminApplication(String host, RestHttpHelper restHelper) {
        return new Application(host, port, "duradmin", restHelper);
    }

    private Application getDurastoreApplication(String host, RestHttpHelper restHelper) {
        return new Application(host, port, "durastore", restHelper);
    }

    private Application getDurabossApplication(String host, RestHttpHelper restHelper) {
        return new Application(host, port, "duraboss", restHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkResponse(String name, RestHttpHelper.HttpResponse response) {
        if (null == response || response.getStatusCode() != 200) {
            String body = null;
            try {
                body = response.getResponseBody();
            }
            catch (IOException e) {}
            finally {
                StringBuilder msg = new StringBuilder("Error Initializing ");
                msg.append(name);
                msg.append(" Response Code: " + response.getStatusCode());
                if (null != body) {
                    msg.append("\nResponse Body:\n");
                    msg.append(body);
                }
                this.log.error(msg.toString());
                throw new DuracloudInstanceUpdateException(msg.toString());
            }
        }
    }
}

