/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.email;

import java.util.List;
import org.duracloud.account.email.EmailUtil;
import org.duracloud.notification.AmazonNotificationFactory;
import org.duracloud.notification.Emailer;

public class EmailUtilImpl
implements EmailUtil {
    private Emailer emailer;
    private String[] recipients;

    public EmailUtilImpl(Emailer emailer, List<String> recipients) {
        this.emailer = emailer;
        this.recipients = recipients.toArray(new String[0]);
    }

    public EmailUtilImpl(String accessKey, String secretKey, String fromAddress, List<String> recipients) {
        this(EmailUtilImpl.getEmailFactory(accessKey, secretKey).getEmailer(fromAddress), recipients);
    }

    private static AmazonNotificationFactory getEmailFactory(String accessKey, String secretKey) {
        AmazonNotificationFactory factory = new AmazonNotificationFactory();
        factory.initialize(accessKey, secretKey);
        return factory;
    }

    @Override
    public void sendEmail(String subject, String body) {
        this.emailer.send(subject, body, this.recipients);
    }
}

