/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.email.EmailUtil;
import org.duracloud.account.email.EmailUtilImpl;
import org.duracloud.account.monitor.duplication.DuplicationMonitorDriver;
import org.duracloud.account.monitor.instance.InstanceMonitorDriver;
import org.duracloud.account.monitor.storereporter.StoreReporterMonitorDriver;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class MonitorsDriver {
    private Logger log = LoggerFactory.getLogger(MonitorsDriver.class);
    private static final String PREFIX = "monitor.";
    private static final String PREFIX_AWS = "monitor.aws.";
    private static final String AWS_USERNAME = "monitor.aws.username";
    private static final String AWS_PASSWORD = "monitor.aws.password";
    private static final String PREFIX_EMAIL = "monitor.email.";
    private static final String FROM_ADDRESS = "monitor.email.from";
    private static final String TO_ADDRESS = "monitor.email.to.";
    private Properties props;
    private EmailUtil emailUtil;
    private DuracloudRepoMgr repoMgr;

    public MonitorsDriver(Properties props) {
        this.props = props;
        this.emailUtil = this.buildEmailUtil(props);
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("jpa-config.xml");
        this.repoMgr = context.getBean("repoMgr", DuracloudRepoMgr.class);
    }

    public DuracloudRepoMgr getRepoMgr() {
        return this.repoMgr;
    }

    public void monitor(Monitor target) {
        this.log.info("starting monitor: {}", (Object)target);
        try {
            target.getMonitorDriver(this.props).run();
        }
        catch (Exception e) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream error = new PrintStream(out);
            error.println("Error in MonitorsDriver: " + e.getMessage());
            e.printStackTrace(error);
            error.flush();
            IOUtils.closeQuietly(out);
            String msg = new String(out.toByteArray());
            this.log.error(msg);
            this.sendEmail("Management Console Monitors Error", msg);
        }
    }

    protected void sendEmail(String subject, String body) {
        this.log.info("Sending email.\nsubject: {} \nbody \n{}", (Object)subject, (Object)body);
        this.emailUtil.sendEmail(subject, body);
    }

    private EmailUtil buildEmailUtil(Properties props) {
        String username = this.getProperty(props, AWS_USERNAME);
        String password = this.getProperty(props, AWS_PASSWORD);
        String fromAddress = this.getProperty(props, FROM_ADDRESS);
        List<String> recipients = this.getEmailRecipients(props, TO_ADDRESS);
        return new EmailUtilImpl(username, password, fromAddress, recipients);
    }

    private List<String> getEmailRecipients(Properties props, String prefix) {
        ArrayList<String> recipients = new ArrayList<String>();
        String recipient = this.getProperty(props, prefix + 0);
        while (null != recipient) {
            recipients.add(recipient);
            try {
                recipient = this.getProperty(props, prefix + recipients.size());
            }
            catch (Exception e) {
                recipient = null;
            }
        }
        return recipients;
    }

    protected String getProperty(Properties props, String key) {
        String property = props.getProperty(key);
        if (null == property) {
            throw new DuraCloudRuntimeException("Property not found: " + key);
        }
        return property;
    }

    private static Properties parseProperties(InputStream stream) throws IOException {
        Properties props = new Properties();
        props.load(stream);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CharSequence msg;
        if (args.length != 2) {
            System.err.println(MonitorsDriver.usage("Invalid number of args: " + args.length));
            System.exit(1);
        }
        String targetName = args[0].toLowerCase();
        Monitor target = null;
        try {
            target = Monitor.valueOf(targetName.toUpperCase());
        }
        catch (Exception e) {
            msg = new StringBuilder("Target must be '");
            ((StringBuilder)msg).append((Object)Monitor.INSTANCE);
            ((StringBuilder)msg).append("' | '");
            ((StringBuilder)msg).append((Object)Monitor.STORE_REPORTER);
            ((StringBuilder)msg).append("' | '");
            ((StringBuilder)msg).append((Object)Monitor.DUPLICATION);
            ((StringBuilder)msg).append("'");
            System.err.println(MonitorsDriver.usage(((StringBuilder)msg).toString()));
            System.exit(1);
        }
        File configFile = new File(args[1]);
        if (!configFile.exists()) {
            msg = "File does not exist: " + configFile.getAbsolutePath();
            System.err.println(MonitorsDriver.usage((String)msg));
            System.exit(1);
        }
        FileInputStream inputStream = null;
        Properties props = null;
        try {
            inputStream = new FileInputStream(configFile);
            props = MonitorsDriver.parseProperties(inputStream);
        }
        catch (IOException e) {
            try {
                System.err.println("Error loading properties: " + e.getMessage());
                System.exit(1);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(inputStream);
        }
        IOUtils.closeQuietly(inputStream);
        MonitorsDriver driver = new MonitorsDriver(props);
        driver.monitor(target);
    }

    private static String usage(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("-----------------------------------------\n");
        sb.append("Error: " + msg);
        sb.append("\n\n");
        sb.append("Usage: ");
        sb.append("MonitorsDriver ");
        sb.append("<instance|store_reporter|duplication> ");
        sb.append("<properties-file>");
        sb.append("\n\t");
        sb.append("Where '");
        sb.append((Object)Monitor.INSTANCE);
        sb.append("', '");
        sb.append((Object)Monitor.STORE_REPORTER);
        sb.append("', or '");
        sb.append((Object)Monitor.DUPLICATION);
        sb.append("' must be provided to indicate the monitoring target.");
        sb.append("\n\t");
        sb.append("And where 'properties-file' contains the necessary ");
        sb.append("initialization config.");
        sb.append("\n\t");
        sb.append("See the example in this jar's 'resources' directory.");
        sb.append("\n");
        sb.append("-----------------------------------------\n");
        return sb.toString();
    }

    public static enum Monitor {
        INSTANCE,
        STORE_REPORTER,
        DUPLICATION;


        public Runnable getMonitorDriver(Properties props) {
            if (this.equals((Object)INSTANCE)) {
                return new InstanceMonitorDriver(props);
            }
            if (this.equals((Object)STORE_REPORTER)) {
                return new StoreReporterMonitorDriver(props);
            }
            if (this.equals((Object)DUPLICATION)) {
                return new DuplicationMonitorDriver(props);
            }
            throw new DuraCloudRuntimeException("Unknown type: " + (Object)((Object)this));
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

