/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.instance.domain;

import java.util.HashMap;
import java.util.Map;

public class InstanceInfo {
    private static final String OK = "OK";
    private String subdomain;
    private String serverStatus;
    private Map<String, String> endpoints;

    public InstanceInfo(String subdomain) {
        this.subdomain = subdomain;
        this.serverStatus = OK;
        this.endpoints = new HashMap<String, String>();
    }

    public boolean hasErrors() {
        if (!this.serverStatus.equals(OK)) {
            return true;
        }
        for (String status : this.endpoints.values()) {
            if (status.equals(OK)) continue;
            return true;
        }
        return false;
    }

    public void setError(String contextPath, String error) {
        this.endpoints.put(contextPath, error);
    }

    public void setSuccess(String contextPath) {
        this.endpoints.put(contextPath, OK);
    }

    public void setServerStatus(String serverStatus) {
        this.serverStatus = serverStatus;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("https://");
        sb.append(this.subdomain);
        sb.append(".duracloud.org status: ");
        if (!this.hasErrors()) {
            sb.append(OK);
        } else {
            sb.append("FAILURE");
            sb.append("\n");
            sb.append(this.getStatusText("\t"));
        }
        return sb.toString();
    }

    private String getStatusText(String indent) {
        StringBuilder errors = new StringBuilder();
        if (!this.serverStatus.equals(OK)) {
            errors.append(this.serverStatus);
            errors.append("\n\n");
        }
        for (String endpoint : this.endpoints.keySet()) {
            String status = this.endpoints.get(endpoint);
            errors.append(indent);
            errors.append("https://");
            errors.append(this.subdomain);
            errors.append(".duracloud.org/");
            errors.append(endpoint);
            errors.append(" (");
            errors.append(status);
            errors.append(")");
            errors.append("\n");
        }
        return errors.toString();
    }
}

