/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.instance.util.impl;

import org.duracloud.account.monitor.error.UnexpectedResponseException;
import org.duracloud.account.monitor.instance.domain.InstanceInfo;
import org.duracloud.account.monitor.instance.domain.WebApplication;
import org.duracloud.account.monitor.instance.util.InstanceUtil;
import org.duracloud.common.util.ExceptionUtil;
import org.duracloud.common.web.RestHttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceUtilImpl
implements InstanceUtil {
    private Logger log = LoggerFactory.getLogger(InstanceUtilImpl.class);
    private WebApplication durastore;
    private WebApplication duraboss;
    private WebApplication duradmin;
    private String subdomain;
    private static final String DOMAIN = ".duracloud.org";
    private static final String PORT = "443";
    private static final String CTXT_STORE = "durastore";
    private static final String CTXT_BOSS = "duraboss";
    private static final String CTXT_ADMIN = "duradmin";
    private static final String PATH_INIT = "/init";

    public InstanceUtilImpl(String subdomain) {
        this(subdomain, null);
    }

    public InstanceUtilImpl(String subdomain, RestHttpHelper restHelper) {
        if (null == restHelper) {
            restHelper = new RestHttpHelper();
        }
        this.subdomain = subdomain;
        String host = subdomain + DOMAIN;
        this.durastore = new WebApplication(host, PORT, CTXT_STORE, restHelper);
        this.duraboss = new WebApplication(host, PORT, CTXT_BOSS, restHelper);
        this.duradmin = new WebApplication(host, PORT, CTXT_ADMIN, restHelper);
    }

    @Override
    public InstanceInfo pingWebApps() {
        InstanceInfo info = new InstanceInfo(this.subdomain);
        this.pingWebApp(this.durastore, PATH_INIT, 200, info);
        this.pingWebApp(this.duraboss, PATH_INIT, 200, info);
        this.pingWebApp(this.duradmin, PATH_INIT, 200, info);
        return info;
    }

    private void pingWebApp(WebApplication app, String path, int statusCode, InstanceInfo info) {
        StringBuilder error = new StringBuilder();
        try {
            app.ping(path, statusCode);
        }
        catch (UnexpectedResponseException e) {
            error.append(e.getMessage());
            this.log.error("Bad response in InstanceUtilImpl.pingWebApp: {}", (Object)error);
        }
        catch (Exception e) {
            error.append(e.getMessage());
            error.append("\n");
            error.append(ExceptionUtil.getStackTraceAsString(e));
            this.log.error("Error in InstanceUtilImpl.pingWebApp: {}", (Object)error);
        }
        String context = app.getContext();
        if (error.length() > 0) {
            info.setError(context + path, error.toString());
        } else {
            info.setSuccess(context + path);
        }
    }
}

