/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.storereporter.util.impl;

import java.util.HashMap;
import java.util.Map;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.monitor.storereporter.util.StoreReporterUtil;
import org.duracloud.account.monitor.storereporter.util.StoreReporterUtilFactory;
import org.duracloud.account.monitor.storereporter.util.impl.StoreReporterUtilImpl;
import org.duracloud.common.model.Credential;

public class StoreReporterUtilFactoryImpl
implements StoreReporterUtilFactory {
    private Map<String, StoreReporterUtil> utils;
    private int thresholdDays;

    public StoreReporterUtilFactoryImpl(int thresholdDays) {
        this.thresholdDays = thresholdDays;
        this.utils = new HashMap<String, StoreReporterUtil>();
    }

    @Override
    public StoreReporterUtil getStoreReporterUtil(AccountInfo acct, Credential credential) {
        String subdomain = acct.getSubdomain();
        StoreReporterUtil util = this.utils.get(subdomain);
        if (null == util) {
            util = new StoreReporterUtilImpl(subdomain, credential, this.thresholdDays);
            this.utils.put(subdomain, util);
        }
        return util;
    }
}

