/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.vote;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.duracloud.common.model.AclType;
import org.duracloud.common.model.RootUserCredential;
import org.duracloud.security.domain.HttpVerb;
import org.duracloud.security.impl.DuracloudUserDetails;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.util.StorageProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.FilterInvocation;

public abstract class SpaceAccessVoter
implements AccessDecisionVoter {
    private final Logger log = LoggerFactory.getLogger(SpaceAccessVoter.class);
    private StorageProviderFactory storageProviderFactory;
    private UserDetailsService userDetailsService;

    public SpaceAccessVoter(StorageProviderFactory storageProviderFactory, UserDetailsService userDetailsService) {
        this.storageProviderFactory = storageProviderFactory;
        this.userDetailsService = userDetailsService;
    }

    protected StorageProviderFactory getStorageProviderFactory() {
        return this.storageProviderFactory;
    }

    protected boolean isOpenResource(HttpServletRequest httpRequest) {
        String spaceId = this.getSpaceId(httpRequest);
        if (null == spaceId) {
            return false;
        }
        return spaceId.equals("spaces") || spaceId.equals("stores") || spaceId.equals("acl") || spaceId.equals("init");
    }

    protected String getStoreId(HttpServletRequest httpRequest) {
        int idIndex;
        String name;
        String storeId = null;
        String query = httpRequest.getQueryString();
        if (null == query) {
            return null;
        }
        int storeIdIndex = (query = query.toLowerCase()).indexOf(name = "storeid");
        if (storeIdIndex > -1 && (idIndex = query.indexOf("=", storeIdIndex) + 1) == storeIdIndex + name.length() + 1) {
            int nextParamIndex = query.indexOf("&", idIndex);
            int end = nextParamIndex > -1 ? nextParamIndex : query.length();
            storeId = query.substring(idIndex, end);
        }
        return storeId;
    }

    protected String getSpaceId(HttpServletRequest httpRequest) {
        int slashIndex;
        String spaceId = httpRequest.getPathInfo();
        if (null == spaceId) {
            return null;
        }
        if (spaceId.startsWith("/")) {
            spaceId = spaceId.substring(1);
        }
        if (spaceId.startsWith("acl/")) {
            spaceId = spaceId.substring("acl/".length());
        }
        if ((slashIndex = spaceId.indexOf("/")) > 0) {
            spaceId = spaceId.substring(0, slashIndex);
        }
        return spaceId;
    }

    protected boolean hasContentId(HttpServletRequest httpRequest) {
        String spaceId = this.getSpaceId(httpRequest);
        if (null != spaceId) {
            String path = httpRequest.getPathInfo();
            return !path.endsWith(spaceId);
        }
        return false;
    }

    protected Map<String, AclType> getSpaceACLs(HttpServletRequest request) {
        HashMap<String, AclType> emptyACLs = new HashMap<String, AclType>();
        String storeId = this.getStoreId(request);
        String spaceId = this.getSpaceId(request);
        if (null == spaceId) {
            return emptyACLs;
        }
        if (spaceId.equals("security") || spaceId.equals("init")) {
            return emptyACLs;
        }
        StorageProvider store = this.getStorageProvider(storeId);
        if (null == store) {
            return emptyACLs;
        }
        try {
            return store.getSpaceACLs(spaceId);
        }
        catch (NotFoundException nfe) {
            this.log.info("Space !exist: {}, exception: {}", (Object)spaceId, (Object)nfe);
            return emptyACLs;
        }
        catch (StorageException e) {
            this.log.warn("Error getting space ACLs: {}, exception: {}", (Object)spaceId, (Object)e);
            return emptyACLs;
        }
    }

    protected HttpVerb getHttpVerb(HttpServletRequest httpRequest) {
        String method = httpRequest.getMethod();
        try {
            return HttpVerb.valueOf(method);
        }
        catch (RuntimeException e) {
            this.log.error("Error determining verb: {}, exception: {}", (Object)method, (Object)e);
            return null;
        }
    }

    protected List<String> getUserGroups(Authentication auth) {
        DuracloudUserDetails userDetails = (DuracloudUserDetails)auth.getPrincipal();
        return userDetails.getGroups();
    }

    protected boolean groupsHaveReadAccess(List<String> userGroups, Map<String, AclType> acls) {
        return this.groupsHaveAccess(userGroups, acls, true);
    }

    protected boolean groupsHaveWriteAccess(List<String> userGroups, Map<String, AclType> acls) {
        return this.groupsHaveAccess(userGroups, acls, false);
    }

    private boolean groupsHaveAccess(List<String> userGroups, Map<String, AclType> acls, boolean isRead) {
        if (null != userGroups) {
            for (String group : userGroups) {
                if (isRead && this.hasReadAccess(group, acls)) {
                    return true;
                }
                if (isRead || !this.hasWriteAccess(group, acls)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasReadAccess(String name, Map<String, AclType> acls) {
        return this.hasAccess(name, acls, true);
    }

    protected boolean hasWriteAccess(String name, Map<String, AclType> acls) {
        return this.hasAccess(name, acls, false);
    }

    private boolean hasAccess(String name, Map<String, AclType> acls, boolean isRead) {
        if (RootUserCredential.getRootUsername().equals(name)) {
            return true;
        }
        if (null == acls) {
            return false;
        }
        String aclName = "acl-" + name;
        if (acls.containsKey(aclName)) {
            AclType acl = acls.get(aclName);
            if (isRead) {
                return AclType.READ.equals((Object)acl) || AclType.WRITE.equals((Object)acl);
            }
            return AclType.WRITE.equals((Object)acl);
        }
        return false;
    }

    protected boolean isAdmin(String name) {
        UserDetails userDetails;
        try {
            userDetails = this.userDetailsService.loadUserByUsername(name);
        }
        catch (UsernameNotFoundException e) {
            this.log.debug("Not admin: {}, error: {}", (Object)name, (Object)e);
            return false;
        }
        for (GrantedAuthority grantedAuthority : userDetails.getAuthorities()) {
            if (!"ROLE_ADMIN".equals(grantedAuthority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    protected StorageProvider getStorageProvider(String storeId) {
        return this.storageProviderFactory.getStorageProvider(storeId);
    }

    protected HttpServletRequest getHttpServletRequest(Object resource) {
        FilterInvocation invocation = (FilterInvocation)resource;
        HttpServletRequest request = invocation.getHttpRequest();
        if (null == request) {
            String msg = "null request: '" + resource + "'";
            this.log.warn("HttpServletRequest was null!  " + msg);
        }
        return request;
    }

    @Override
    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public boolean supports(Class aClass) {
        return FilterInvocation.class.isAssignableFrom(aClass);
    }
}

