/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ReaderContext;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.repository.config.RepositoryConfigurationDelegate;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

public class RepositoryBeanDefinitionParser
implements BeanDefinitionParser {
    private final RepositoryConfigurationExtension extension;

    public RepositoryBeanDefinitionParser(RepositoryConfigurationExtension extension) {
        Assert.notNull(extension);
        this.extension = extension;
    }

    @Override
    public BeanDefinition parse(Element element, ParserContext parser) {
        try {
            Environment environment = parser.getDelegate().getEnvironment();
            ResourceLoader resourceLoader = parser.getReaderContext().getResourceLoader();
            XmlRepositoryConfigurationSource configSource = new XmlRepositoryConfigurationSource(element, parser, environment);
            RepositoryConfigurationDelegate delegate = new RepositoryConfigurationDelegate(configSource, resourceLoader, environment);
            for (BeanComponentDefinition definition : delegate.registerRepositoriesIn(parser.getRegistry(), this.extension)) {
                parser.registerBeanComponent(definition);
            }
        }
        catch (RuntimeException e) {
            this.handleError(e, element, parser.getReaderContext());
        }
        return null;
    }

    private void handleError(Exception e, Element source, ReaderContext reader) {
        reader.error(e.getMessage(), reader.extractSource(source), e);
    }

    protected static boolean hasBean(Class<?> type, BeanDefinitionRegistry registry) {
        String name = String.format("%s%s0", type.getName(), "#");
        return registry.containsBeanDefinition(name);
    }
}

