/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.ComputeProviderAccount;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.ServerDetails;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.model.UserInvitation;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.db.util.error.AccessDeniedException;
import org.duracloud.account.db.util.security.AnnotationParser;
import org.duracloud.account.db.util.security.impl.MethodInvocationImpl;
import org.duracloud.notification.Emailer;
import org.duracloud.storage.domain.StorageProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.core.Authentication;

public class AccountServiceSecuredImpl
implements AccountService {
    private Logger log = LoggerFactory.getLogger(AccountServiceSecuredImpl.class);
    private AccountService accountService;
    private Authentication authentication;
    private AccessDecisionVoter voter;
    private Map<String, Object[]> methodMap;

    public AccountServiceSecuredImpl(AccountService accountService, Authentication authentication, AccessDecisionVoter voter, AnnotationParser annotationParser) {
        this.accountService = accountService;
        this.authentication = authentication;
        this.voter = voter;
        this.methodMap = annotationParser.getMethodAnnotationsForClass(Secured.class, this.getClass());
    }

    private void throwIfAccessDenied(Object ... args) {
        String methodName = this.getCurrentMethodName();
        HashSet<ConfigAttribute> configAtts = new HashSet<ConfigAttribute>();
        for (Object obj : this.methodMap.get(methodName)) {
            configAtts.add(new SecurityConfig((String)obj));
        }
        MethodInvocationImpl invocation = new MethodInvocationImpl(this, methodName, args);
        int decision = this.voter.vote(this.authentication, invocation, configAtts);
        if (decision != 1) {
            throw new AccessDeniedException("Access denied");
        }
    }

    private String getCurrentMethodName() {
        return Thread.currentThread().getStackTrace()[3].getMethodName();
    }

    @Override
    public Long getAccountId() {
        this.throwIfAccessDenied(new Object[0]);
        return this.accountService.getAccountId();
    }

    @Override
    public AccountInfo retrieveAccountInfo() {
        this.throwIfAccessDenied(new Object[0]);
        return this.accountService.retrieveAccountInfo();
    }

    @Override
    public void storeAccountInfo(String acctName, String orgName, String department) {
        this.throwIfAccessDenied(acctName, orgName, department);
        this.accountService.storeAccountInfo(acctName, orgName, department);
    }

    @Override
    public void storeAccountStatus(AccountInfo.AccountStatus status) {
        this.throwIfAccessDenied(new Object[]{status});
        this.accountService.storeAccountStatus(status);
    }

    @Override
    public void storeSubdomain(String subdomain) {
        this.throwIfAccessDenied(subdomain);
        this.accountService.storeSubdomain(subdomain);
    }

    @Override
    public String getSubdomain() {
        this.throwIfAccessDenied(new Object[0]);
        return this.accountService.getSubdomain();
    }

    @Override
    public StorageProviderAccount getPrimaryStorageProvider() {
        this.throwIfAccessDenied(new Object[0]);
        return this.accountService.getPrimaryStorageProvider();
    }

    @Override
    public void setPrimaryStorageProviderRrs(boolean rrs) {
        this.throwIfAccessDenied(new Object[0]);
        this.accountService.setPrimaryStorageProviderRrs(rrs);
    }

    @Override
    public Set<StorageProviderAccount> getSecondaryStorageProviders() {
        this.throwIfAccessDenied(new Object[0]);
        return this.accountService.getSecondaryStorageProviders();
    }

    @Override
    public void addStorageProvider(StorageProviderType storageProviderType) {
        this.throwIfAccessDenied(new Object[]{storageProviderType});
        this.accountService.addStorageProvider(storageProviderType);
    }

    @Override
    public void removeStorageProvider(Long storageProviderId) {
        this.throwIfAccessDenied(storageProviderId);
        this.accountService.removeStorageProvider(storageProviderId);
    }

    @Override
    public Set<DuracloudUser> getUsers() {
        this.throwIfAccessDenied(new Object[0]);
        return this.accountService.getUsers();
    }

    @Override
    public UserInvitation inviteUser(String emailAddress, String adminUsername, Emailer emailer) {
        this.throwIfAccessDenied(emailAddress, adminUsername, emailer);
        return this.accountService.inviteUser(emailAddress, adminUsername, emailer);
    }

    @Override
    public Set<UserInvitation> getPendingInvitations() {
        this.throwIfAccessDenied(new Object[0]);
        return this.accountService.getPendingInvitations();
    }

    @Override
    public void deleteUserInvitation(Long invitationId) {
        this.throwIfAccessDenied(invitationId);
        this.accountService.deleteUserInvitation(invitationId);
    }

    @Override
    public ServerDetails retrieveServerDetails() {
        this.throwIfAccessDenied(new Object[0]);
        return this.accountService.retrieveServerDetails();
    }

    @Override
    public void storeServerDetails(ServerDetails serverDetails) {
        this.throwIfAccessDenied(serverDetails);
        this.accountService.storeServerDetails(serverDetails);
    }

    @Override
    public ComputeProviderAccount getComputeProvider() {
        this.throwIfAccessDenied(new Object[0]);
        return this.accountService.getComputeProvider();
    }
}

