/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.instance.impl;

import java.io.IOException;
import org.duracloud.account.db.util.error.DuracloudInstanceUpdateException;
import org.duracloud.account.db.util.instance.InstanceAccessUtil;
import org.duracloud.account.db.util.instance.InstanceUtil;
import org.duracloud.common.web.RestHttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceAccessUtilImpl
implements InstanceAccessUtil,
InstanceUtil {
    private Logger log = LoggerFactory.getLogger(InstanceAccessUtilImpl.class);
    private static final String PROTOCOL = "https://";
    private static final String INIT_PATH = "/init";
    private static final int SLEEP_TIME = 10000;

    @Override
    public void waitInstanceAvailable(String hostname, long timeout) {
        this.log.debug("Waiting for instance at {} to become available", (Object)hostname);
        long start = System.currentTimeMillis();
        while (!this.instanceAvailable(hostname)) {
            long now = System.currentTimeMillis();
            if (now - start > timeout) {
                String error = "Instance at host " + hostname + " was not available prior to wait timeout of " + timeout + " milliseconds.";
                throw new DuracloudInstanceUpdateException(error);
            }
            this.sleep(10000);
        }
        this.log.debug("Instance at {} is now available.", (Object)hostname);
    }

    private void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean instanceAvailable(String hostname) {
        RestHttpHelper restHelper = new RestHttpHelper();
        String duradminUrl = PROTOCOL + hostname + "/" + "duradmin" + INIT_PATH;
        String durastoreUrl = PROTOCOL + hostname + "/" + "durastore" + INIT_PATH;
        String durareportUrl = PROTOCOL + hostname + "/" + "duraboss" + INIT_PATH;
        try {
            return this.checkResponse(restHelper.get(duradminUrl)) && this.checkResponse(restHelper.get(durastoreUrl)) && this.checkResponse(restHelper.get(durareportUrl));
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkResponse(RestHttpHelper.HttpResponse response) {
        int statusCode = response.getStatusCode();
        if (statusCode == 200) {
            return true;
        }
        if (statusCode == 503) {
            try {
                return response.getResponseBody().contains("DuraCloud");
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }
}

