/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.instance.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.monitor.instance.domain.InstanceInfo;

public class InstanceReport {
    private Map<AccountInfo, InstanceInfo> instanceInfos = new HashMap<AccountInfo, InstanceInfo>();

    public void addAcctError(AccountInfo acct, String error) {
        InstanceInfo instance = new InstanceInfo(acct.getSubdomain());
        instance.setServerStatus(error);
        this.instanceInfos.put(acct, instance);
    }

    public void addAcctInstance(AccountInfo acct, InstanceInfo instanceInfo) {
        this.instanceInfos.put(acct, instanceInfo);
    }

    public Map<AccountInfo, InstanceInfo> getInstanceInfos() {
        return this.instanceInfos;
    }

    public Map<AccountInfo, InstanceInfo> getInstanceErrors() {
        HashMap<AccountInfo, InstanceInfo> instanceErrors = new HashMap<AccountInfo, InstanceInfo>();
        for (AccountInfo acct : this.instanceInfos.keySet()) {
            InstanceInfo instance = this.instanceInfos.get(acct);
            if (!instance.hasErrors()) continue;
            instanceErrors.put(acct, instance);
        }
        return instanceErrors;
    }

    public boolean hasErrors() {
        for (InstanceInfo instance : this.instanceInfos.values()) {
            if (!instance.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("---------------------\n");
        sb.append("Accounts with errors:\n");
        sb.append("---------------------\n");
        ArrayList<AccountInfo> accts = new ArrayList<AccountInfo>();
        for (AccountInfo acct : this.instanceInfos.keySet()) {
            accts.add(acct);
        }
        Collections.sort(accts);
        for (AccountInfo acctInfo : accts) {
            InstanceInfo instanceInfo = this.instanceInfos.get(acctInfo);
            if (null == instanceInfo || !instanceInfo.hasErrors()) continue;
            sb.append("Account: (");
            sb.append(acctInfo.getAcctName());
            sb.append(") ");
            sb.append(instanceInfo);
            sb.append("\n\n");
        }
        return sb.toString();
    }
}

