/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.storereporter;

import java.util.List;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.DuracloudInstance;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.account.db.repo.DuracloudInstanceRepo;
import org.duracloud.account.db.repo.DuracloudServerImageRepo;
import org.duracloud.account.monitor.common.BaseMonitor;
import org.duracloud.account.monitor.storereporter.domain.StoreReporterReport;
import org.duracloud.account.monitor.storereporter.util.StoreReporterUtil;
import org.duracloud.account.monitor.storereporter.util.StoreReporterUtilFactory;
import org.duracloud.common.model.Credential;
import org.duracloud.common.util.ExceptionUtil;
import org.slf4j.LoggerFactory;

public class StoreReporterMonitor
extends BaseMonitor {
    private StoreReporterUtilFactory reporterUtilFactory;

    public StoreReporterMonitor(DuracloudAccountRepo acctRepo, DuracloudInstanceRepo instanceRepo, DuracloudServerImageRepo imageRepo, StoreReporterUtilFactory factory) {
        this.log = LoggerFactory.getLogger(StoreReporterMonitor.class);
        super.init(acctRepo, instanceRepo, imageRepo);
        this.reporterUtilFactory = factory;
    }

    public StoreReporterReport monitorStoreReporters() {
        this.log.info("starting store-reporter monitor");
        StoreReporterReport report = new StoreReporterReport();
        List<DuracloudInstance> instances = this.getDuracloudInstances();
        for (DuracloudInstance instance : instances) {
            this.doMonitorStoreReporters(report, instance);
        }
        return report;
    }

    private void doMonitorStoreReporters(StoreReporterReport report, DuracloudInstance instance) {
        AccountInfo acct = instance.getAccount();
        this.log.info("monitoring store-reporter: {} ({})", (Object)acct.getAcctName(), (Object)acct.getSubdomain());
        try {
            Credential credential = this.getRootCredential(instance);
            StoreReporterUtil reporterUtil = this.reporterUtilFactory.getStoreReporterUtil(acct, credential);
            report.addAcctInfo(acct, reporterUtil.pingStorageReporter());
        }
        catch (Exception e) {
            StringBuilder error = new StringBuilder("Error ");
            error.append("monitoring store-reporter for account: ");
            error.append(acct.getSubdomain());
            error.append("\n");
            error.append("msg: \n");
            error.append(e.getMessage());
            error.append("\n");
            error.append("stack trace: \n");
            error.append(ExceptionUtil.getStackTraceAsString(e));
            this.log.error(error.toString());
            report.addAcctError(acct, error.toString());
        }
    }
}

