/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.storereporter.util.impl;

import java.util.Calendar;
import org.duracloud.account.monitor.storereporter.domain.StoreReporterInfo;
import org.duracloud.account.monitor.storereporter.util.StoreReporterUtil;
import org.duracloud.client.report.StorageReportManager;
import org.duracloud.client.report.StorageReportManagerImpl;
import org.duracloud.client.report.error.ReportException;
import org.duracloud.common.model.Credential;
import org.duracloud.common.util.ExceptionUtil;
import org.duracloud.reportdata.storage.StorageReportInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreReporterUtilImpl
implements StoreReporterUtil {
    private Logger log = LoggerFactory.getLogger(StoreReporterUtilImpl.class);
    private StorageReportManager reportManager;
    private String subdomain;
    private int thresholdDays;
    private static final String DOMAIN = ".duracloud.org";
    private static final String PORT = "443";
    private static final String CTXT_BOSS = "duraboss";

    public StoreReporterUtilImpl(String subdomain, Credential credential, int thresholdDays) {
        this(subdomain, credential, thresholdDays, null);
    }

    public StoreReporterUtilImpl(String subdomain, Credential credential, int thresholdDays, StorageReportManager reportManager) {
        if (null == reportManager) {
            String host = subdomain + DOMAIN;
            reportManager = new StorageReportManagerImpl(host, PORT, CTXT_BOSS);
            reportManager.login(credential);
        }
        this.subdomain = subdomain;
        this.thresholdDays = thresholdDays;
        this.reportManager = reportManager;
    }

    @Override
    public StoreReporterInfo pingStorageReporter() {
        StorageReportInfo reportInfo = null;
        StringBuilder error = new StringBuilder();
        try {
            reportInfo = this.reportManager.getStorageReportInfo();
        }
        catch (ReportException e) {
            error.append(e.getMessage());
            error.append("\n");
            error.append(ExceptionUtil.getStackTraceAsString(e));
            this.log.error("Error StoreReportUtil.pingStorageReporter: {}", (Object)error);
        }
        if (null == reportInfo) {
            error.append("Unable to collect StorageReportInfo: null");
        } else {
            long nextStart = reportInfo.getNextScheduledStartTime();
            if (this.isThresholdDaysAgo(nextStart)) {
                error.append("Next scheduled storage report is more than ");
                error.append(this.thresholdDays);
                error.append(" days AGO.");
                error.append("\n");
            }
        }
        StoreReporterInfo result = new StoreReporterInfo(this.subdomain);
        if (error.length() > 0) {
            result.setError(error.toString());
        } else {
            result.setSuccess();
        }
        return result;
    }

    private boolean isThresholdDaysAgo(long timeMillis) {
        Calendar nextDate = Calendar.getInstance();
        nextDate.setTimeInMillis(timeMillis);
        Calendar thresholdDaysAgo = Calendar.getInstance();
        thresholdDaysAgo.add(5, -this.thresholdDays);
        return nextDate.before(thresholdDaysAgo);
    }
}

