/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import java.util.Date;

public class STSAssumeRoleSessionCredentialsProvider
implements AWSCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 900;
    private static final int EXPIRY_TIME_MILLIS = 60000;
    private final AWSSecurityTokenService securityTokenService;
    private AWSSessionCredentials sessionCredentials;
    private Date sessionCredentialsExpiration;
    private String roleArn;
    private String roleSessionName;
    private String roleExternalId;

    public STSAssumeRoleSessionCredentialsProvider(String roleArn, String roleSessionName) {
        this(new Builder(roleArn, roleSessionName));
    }

    public STSAssumeRoleSessionCredentialsProvider(AWSCredentials longLivedCredentials, String roleArn, String roleSessionName) {
        this(longLivedCredentials, roleArn, roleSessionName, new ClientConfiguration());
    }

    public STSAssumeRoleSessionCredentialsProvider(AWSCredentials longLivedCredentials, String roleArn, String roleSessionName, ClientConfiguration clientConfiguration) {
        this(new Builder(roleArn, roleSessionName).withLongLivedCredentials(longLivedCredentials).withClientConfiguration(clientConfiguration));
    }

    public STSAssumeRoleSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider, String roleArn, String roleSessionName) {
        this(new Builder(roleArn, roleSessionName).withLongLivedCredentialsProvider(longLivedCredentialsProvider));
    }

    public STSAssumeRoleSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider, String roleArn, String roleSessionName, ClientConfiguration clientConfiguration) {
        this(new Builder(roleArn, roleSessionName).withLongLivedCredentialsProvider(longLivedCredentialsProvider).withClientConfiguration(clientConfiguration));
    }

    private STSAssumeRoleSessionCredentialsProvider(Builder builder) {
        if (builder.longLivedCredentials != null && builder.longLivedCredentialsProvider != null) {
            throw new IllegalArgumentException("It is illegal to set both an AWSCredentials and an AWSCredentialsProvider for an " + STSAssumeRoleSessionCredentialsProvider.class.getName());
        }
        this.roleArn = builder.roleArn;
        this.roleSessionName = builder.roleSessionName;
        this.roleExternalId = builder.roleExternalId;
        AWSCredentialsProvider longLivedCredentialsProvider = null;
        if (builder.longLivedCredentials != null) {
            longLivedCredentialsProvider = new StaticCredentialsProvider(builder.longLivedCredentials);
        } else if (builder.longLivedCredentialsProvider != null) {
            longLivedCredentialsProvider = builder.longLivedCredentialsProvider;
        }
        this.securityTokenService = longLivedCredentialsProvider == null ? (builder.clientConfiguration == null ? new AWSSecurityTokenServiceClient() : new AWSSecurityTokenServiceClient(builder.clientConfiguration)) : (builder.clientConfiguration == null ? new AWSSecurityTokenServiceClient(longLivedCredentialsProvider) : new AWSSecurityTokenServiceClient(longLivedCredentialsProvider, builder.clientConfiguration));
        if (builder.serviceEndpoint != null) {
            this.securityTokenService.setEndpoint(builder.serviceEndpoint);
        }
    }

    public void setSTSClientEndpoint(String endpoint) {
        this.securityTokenService.setEndpoint(endpoint);
        this.sessionCredentials = null;
    }

    @Override
    public AWSCredentials getCredentials() {
        if (this.needsNewSession()) {
            this.startSession();
        }
        return this.sessionCredentials;
    }

    @Override
    public void refresh() {
        this.startSession();
    }

    private void startSession() {
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withRoleArn(this.roleArn).withDurationSeconds(900).withRoleSessionName(this.roleSessionName);
        if (this.roleExternalId != null) {
            assumeRoleRequest = assumeRoleRequest.withExternalId(this.roleExternalId);
        }
        AssumeRoleResult assumeRoleResult = this.securityTokenService.assumeRole(assumeRoleRequest);
        Credentials stsCredentials = assumeRoleResult.getCredentials();
        this.sessionCredentials = new BasicSessionCredentials(stsCredentials.getAccessKeyId(), stsCredentials.getSecretAccessKey(), stsCredentials.getSessionToken());
        this.sessionCredentialsExpiration = stsCredentials.getExpiration();
    }

    private boolean needsNewSession() {
        if (this.sessionCredentials == null) {
            return true;
        }
        long timeRemaining = this.sessionCredentialsExpiration.getTime() - System.currentTimeMillis();
        return timeRemaining < 60000L;
    }

    public static final class Builder {
        private AWSCredentialsProvider longLivedCredentialsProvider;
        private AWSCredentials longLivedCredentials;
        private ClientConfiguration clientConfiguration;
        private final String roleArn;
        private final String roleSessionName;
        private String roleExternalId;
        private String serviceEndpoint;

        public Builder(String roleArn, String roleSessionName) {
            if (roleArn == null || roleSessionName == null) {
                throw new NullPointerException("You must specify a value for roleArn and roleSessionName");
            }
            this.roleArn = roleArn;
            this.roleSessionName = roleSessionName;
        }

        public Builder withLongLivedCredentials(AWSCredentials longLivedCredentials) {
            this.longLivedCredentials = longLivedCredentials;
            return this;
        }

        public Builder withLongLivedCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider) {
            this.longLivedCredentialsProvider = longLivedCredentialsProvider;
            return this;
        }

        public Builder withClientConfiguration(ClientConfiguration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public Builder withExternalId(String roleExternalId) {
            this.roleExternalId = roleExternalId;
            return this;
        }

        public Builder withServiceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
            return this;
        }

        public STSAssumeRoleSessionCredentialsProvider build() {
            return new STSAssumeRoleSessionCredentialsProvider(this);
        }
    }
}

