/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.ParameterObject;
import com.amazonaws.services.datapipeline.model.ParameterValue;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutPipelineDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String pipelineId;
    private ListWithAutoConstructFlag<PipelineObject> pipelineObjects;
    private ListWithAutoConstructFlag<ParameterObject> parameterObjects;
    private ListWithAutoConstructFlag<ParameterValue> parameterValues;

    public String getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public PutPipelineDefinitionRequest withPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
        return this;
    }

    public List<PipelineObject> getPipelineObjects() {
        if (this.pipelineObjects == null) {
            this.pipelineObjects = new ListWithAutoConstructFlag();
            this.pipelineObjects.setAutoConstruct(true);
        }
        return this.pipelineObjects;
    }

    public void setPipelineObjects(Collection<PipelineObject> pipelineObjects) {
        if (pipelineObjects == null) {
            this.pipelineObjects = null;
            return;
        }
        ListWithAutoConstructFlag pipelineObjectsCopy = new ListWithAutoConstructFlag(pipelineObjects.size());
        pipelineObjectsCopy.addAll(pipelineObjects);
        this.pipelineObjects = pipelineObjectsCopy;
    }

    public PutPipelineDefinitionRequest withPipelineObjects(PipelineObject ... pipelineObjects) {
        if (this.getPipelineObjects() == null) {
            this.setPipelineObjects(new ArrayList<PipelineObject>(pipelineObjects.length));
        }
        for (PipelineObject value : pipelineObjects) {
            this.getPipelineObjects().add(value);
        }
        return this;
    }

    public PutPipelineDefinitionRequest withPipelineObjects(Collection<PipelineObject> pipelineObjects) {
        if (pipelineObjects == null) {
            this.pipelineObjects = null;
        } else {
            ListWithAutoConstructFlag pipelineObjectsCopy = new ListWithAutoConstructFlag(pipelineObjects.size());
            pipelineObjectsCopy.addAll(pipelineObjects);
            this.pipelineObjects = pipelineObjectsCopy;
        }
        return this;
    }

    public List<ParameterObject> getParameterObjects() {
        if (this.parameterObjects == null) {
            this.parameterObjects = new ListWithAutoConstructFlag();
            this.parameterObjects.setAutoConstruct(true);
        }
        return this.parameterObjects;
    }

    public void setParameterObjects(Collection<ParameterObject> parameterObjects) {
        if (parameterObjects == null) {
            this.parameterObjects = null;
            return;
        }
        ListWithAutoConstructFlag parameterObjectsCopy = new ListWithAutoConstructFlag(parameterObjects.size());
        parameterObjectsCopy.addAll(parameterObjects);
        this.parameterObjects = parameterObjectsCopy;
    }

    public PutPipelineDefinitionRequest withParameterObjects(ParameterObject ... parameterObjects) {
        if (this.getParameterObjects() == null) {
            this.setParameterObjects(new ArrayList<ParameterObject>(parameterObjects.length));
        }
        for (ParameterObject value : parameterObjects) {
            this.getParameterObjects().add(value);
        }
        return this;
    }

    public PutPipelineDefinitionRequest withParameterObjects(Collection<ParameterObject> parameterObjects) {
        if (parameterObjects == null) {
            this.parameterObjects = null;
        } else {
            ListWithAutoConstructFlag parameterObjectsCopy = new ListWithAutoConstructFlag(parameterObjects.size());
            parameterObjectsCopy.addAll(parameterObjects);
            this.parameterObjects = parameterObjectsCopy;
        }
        return this;
    }

    public List<ParameterValue> getParameterValues() {
        if (this.parameterValues == null) {
            this.parameterValues = new ListWithAutoConstructFlag();
            this.parameterValues.setAutoConstruct(true);
        }
        return this.parameterValues;
    }

    public void setParameterValues(Collection<ParameterValue> parameterValues) {
        if (parameterValues == null) {
            this.parameterValues = null;
            return;
        }
        ListWithAutoConstructFlag parameterValuesCopy = new ListWithAutoConstructFlag(parameterValues.size());
        parameterValuesCopy.addAll(parameterValues);
        this.parameterValues = parameterValuesCopy;
    }

    public PutPipelineDefinitionRequest withParameterValues(ParameterValue ... parameterValues) {
        if (this.getParameterValues() == null) {
            this.setParameterValues(new ArrayList<ParameterValue>(parameterValues.length));
        }
        for (ParameterValue value : parameterValues) {
            this.getParameterValues().add(value);
        }
        return this;
    }

    public PutPipelineDefinitionRequest withParameterValues(Collection<ParameterValue> parameterValues) {
        if (parameterValues == null) {
            this.parameterValues = null;
        } else {
            ListWithAutoConstructFlag parameterValuesCopy = new ListWithAutoConstructFlag(parameterValues.size());
            parameterValuesCopy.addAll(parameterValues);
            this.parameterValues = parameterValuesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: " + this.getPipelineId() + ",");
        }
        if (this.getPipelineObjects() != null) {
            sb.append("PipelineObjects: " + this.getPipelineObjects() + ",");
        }
        if (this.getParameterObjects() != null) {
            sb.append("ParameterObjects: " + this.getParameterObjects() + ",");
        }
        if (this.getParameterValues() != null) {
            sb.append("ParameterValues: " + this.getParameterValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineObjects() == null ? 0 : this.getPipelineObjects().hashCode());
        hashCode = 31 * hashCode + (this.getParameterObjects() == null ? 0 : this.getParameterObjects().hashCode());
        hashCode = 31 * hashCode + (this.getParameterValues() == null ? 0 : this.getParameterValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPipelineDefinitionRequest)) {
            return false;
        }
        PutPipelineDefinitionRequest other = (PutPipelineDefinitionRequest)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getPipelineObjects() == null ^ this.getPipelineObjects() == null) {
            return false;
        }
        if (other.getPipelineObjects() != null && !other.getPipelineObjects().equals(this.getPipelineObjects())) {
            return false;
        }
        if (other.getParameterObjects() == null ^ this.getParameterObjects() == null) {
            return false;
        }
        if (other.getParameterObjects() != null && !other.getParameterObjects().equals(this.getParameterObjects())) {
            return false;
        }
        if (other.getParameterValues() == null ^ this.getParameterValues() == null) {
            return false;
        }
        return other.getParameterValues() == null || other.getParameterValues().equals(this.getParameterValues());
    }
}

