/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.identitymanagement.model.PolicyVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPolicyVersionsResult
implements Serializable {
    private ListWithAutoConstructFlag<PolicyVersion> versions;
    private Boolean isTruncated;
    private String marker;

    public List<PolicyVersion> getVersions() {
        if (this.versions == null) {
            this.versions = new ListWithAutoConstructFlag();
            this.versions.setAutoConstruct(true);
        }
        return this.versions;
    }

    public void setVersions(Collection<PolicyVersion> versions) {
        if (versions == null) {
            this.versions = null;
            return;
        }
        ListWithAutoConstructFlag versionsCopy = new ListWithAutoConstructFlag(versions.size());
        versionsCopy.addAll(versions);
        this.versions = versionsCopy;
    }

    public ListPolicyVersionsResult withVersions(PolicyVersion ... versions) {
        if (this.getVersions() == null) {
            this.setVersions(new ArrayList<PolicyVersion>(versions.length));
        }
        for (PolicyVersion value : versions) {
            this.getVersions().add(value);
        }
        return this;
    }

    public ListPolicyVersionsResult withVersions(Collection<PolicyVersion> versions) {
        if (versions == null) {
            this.versions = null;
        } else {
            ListWithAutoConstructFlag versionsCopy = new ListWithAutoConstructFlag(versions.size());
            versionsCopy.addAll(versions);
            this.versions = versionsCopy;
        }
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public ListPolicyVersionsResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListPolicyVersionsResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVersions() != null) {
            sb.append("Versions: " + this.getVersions() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVersions() == null ? 0 : this.getVersions().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyVersionsResult)) {
            return false;
        }
        ListPolicyVersionsResult other = (ListPolicyVersionsResult)obj;
        if (other.getVersions() == null ^ this.getVersions() == null) {
            return false;
        }
        if (other.getVersions() != null && !other.getVersions().equals(this.getVersions())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }
}

