/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListHostedZonesByNameRequest;
import com.amazonaws.transform.Marshaller;

public class ListHostedZonesByNameRequestMarshaller
implements Marshaller<Request<ListHostedZonesByNameRequest>, ListHostedZonesByNameRequest> {
    @Override
    public Request<ListHostedZonesByNameRequest> marshall(ListHostedZonesByNameRequest listHostedZonesByNameRequest) {
        if (listHostedZonesByNameRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListHostedZonesByNameRequest> request = new DefaultRequest<ListHostedZonesByNameRequest>(listHostedZonesByNameRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/hostedzonesbyname?dnsname={DNSName}&hostedzoneid={HostedZoneId}&maxitems={MaxItems}";
        uriResourcePath = uriResourcePath.replace("{DNSName}", this.getString(listHostedZonesByNameRequest.getDNSName()));
        uriResourcePath = uriResourcePath.replace("{HostedZoneId}", this.getString(listHostedZonesByNameRequest.getHostedZoneId()));
        uriResourcePath = uriResourcePath.replace("{MaxItems}", this.getString(listHostedZonesByNameRequest.getMaxItems()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

