/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeInstancesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String stackId;
    private String layerId;
    private ListWithAutoConstructFlag<String> instanceIds;

    public String getStackId() {
        return this.stackId;
    }

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public DescribeInstancesRequest withStackId(String stackId) {
        this.stackId = stackId;
        return this;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public void setLayerId(String layerId) {
        this.layerId = layerId;
    }

    public DescribeInstancesRequest withLayerId(String layerId) {
        this.layerId = layerId;
        return this;
    }

    public List<String> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new ListWithAutoConstructFlag();
            this.instanceIds.setAutoConstruct(true);
        }
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        ListWithAutoConstructFlag instanceIdsCopy = new ListWithAutoConstructFlag(instanceIds.size());
        instanceIdsCopy.addAll(instanceIds);
        this.instanceIds = instanceIdsCopy;
    }

    public DescribeInstancesRequest withInstanceIds(String ... instanceIds) {
        if (this.getInstanceIds() == null) {
            this.setInstanceIds(new ArrayList<String>(instanceIds.length));
        }
        for (String value : instanceIds) {
            this.getInstanceIds().add(value);
        }
        return this;
    }

    public DescribeInstancesRequest withInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
        } else {
            ListWithAutoConstructFlag instanceIdsCopy = new ListWithAutoConstructFlag(instanceIds.size());
            instanceIdsCopy.addAll(instanceIds);
            this.instanceIds = instanceIdsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackId() != null) {
            sb.append("StackId: " + this.getStackId() + ",");
        }
        if (this.getLayerId() != null) {
            sb.append("LayerId: " + this.getLayerId() + ",");
        }
        if (this.getInstanceIds() != null) {
            sb.append("InstanceIds: " + this.getInstanceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getLayerId() == null ? 0 : this.getLayerId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesRequest)) {
            return false;
        }
        DescribeInstancesRequest other = (DescribeInstancesRequest)obj;
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getLayerId() == null ^ this.getLayerId() == null) {
            return false;
        }
        if (other.getLayerId() != null && !other.getLayerId().equals(this.getLayerId())) {
            return false;
        }
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        return other.getInstanceIds() == null || other.getInstanceIds().equals(this.getInstanceIds());
    }
}

