/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpledb.model.Attribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Item
implements Serializable {
    private String name;
    private String alternateNameEncoding;
    private ListWithAutoConstructFlag<Attribute> attributes;

    public Item() {
    }

    public Item(String name, List<Attribute> attributes) {
        this.setName(name);
        this.setAttributes(attributes);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Item withName(String name) {
        this.name = name;
        return this;
    }

    public String getAlternateNameEncoding() {
        return this.alternateNameEncoding;
    }

    public void setAlternateNameEncoding(String alternateNameEncoding) {
        this.alternateNameEncoding = alternateNameEncoding;
    }

    public Item withAlternateNameEncoding(String alternateNameEncoding) {
        this.alternateNameEncoding = alternateNameEncoding;
        return this;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ListWithAutoConstructFlag();
            this.attributes.setAutoConstruct(true);
        }
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        ListWithAutoConstructFlag attributesCopy = new ListWithAutoConstructFlag(attributes.size());
        attributesCopy.addAll(attributes);
        this.attributes = attributesCopy;
    }

    public Item withAttributes(Attribute ... attributes) {
        if (this.getAttributes() == null) {
            this.setAttributes(new ArrayList<Attribute>(attributes.length));
        }
        for (Attribute value : attributes) {
            this.getAttributes().add(value);
        }
        return this;
    }

    public Item withAttributes(Collection<Attribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
        } else {
            ListWithAutoConstructFlag attributesCopy = new ListWithAutoConstructFlag(attributes.size());
            attributesCopy.addAll(attributes);
            this.attributes = attributesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getAlternateNameEncoding() != null) {
            sb.append("AlternateNameEncoding: " + this.getAlternateNameEncoding() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getAlternateNameEncoding() == null ? 0 : this.getAlternateNameEncoding().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getAlternateNameEncoding() == null ^ this.getAlternateNameEncoding() == null) {
            return false;
        }
        if (other.getAlternateNameEncoding() != null && !other.getAlternateNameEncoding().equals(this.getAlternateNameEncoding())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }
}

