/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simplesystemsmanagement.model.Association;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAssociationsResult
implements Serializable {
    private ListWithAutoConstructFlag<Association> associations;
    private String nextToken;

    public List<Association> getAssociations() {
        if (this.associations == null) {
            this.associations = new ListWithAutoConstructFlag();
            this.associations.setAutoConstruct(true);
        }
        return this.associations;
    }

    public void setAssociations(Collection<Association> associations) {
        if (associations == null) {
            this.associations = null;
            return;
        }
        ListWithAutoConstructFlag associationsCopy = new ListWithAutoConstructFlag(associations.size());
        associationsCopy.addAll(associations);
        this.associations = associationsCopy;
    }

    public ListAssociationsResult withAssociations(Association ... associations) {
        if (this.getAssociations() == null) {
            this.setAssociations(new ArrayList<Association>(associations.length));
        }
        for (Association value : associations) {
            this.getAssociations().add(value);
        }
        return this;
    }

    public ListAssociationsResult withAssociations(Collection<Association> associations) {
        if (associations == null) {
            this.associations = null;
        } else {
            ListWithAutoConstructFlag associationsCopy = new ListWithAutoConstructFlag(associations.size());
            associationsCopy.addAll(associations);
            this.associations = associationsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListAssociationsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssociations() != null) {
            sb.append("Associations: " + this.getAssociations() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssociations() == null ? 0 : this.getAssociations().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationsResult)) {
            return false;
        }
        ListAssociationsResult other = (ListAssociationsResult)obj;
        if (other.getAssociations() == null ^ this.getAssociations() == null) {
            return false;
        }
        if (other.getAssociations() != null && !other.getAssociations().equals(this.getAssociations())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

