/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.buffered;

import com.amazonaws.AmazonClientException;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.buffered.QueueBufferCallback;
import com.amazonaws.services.sqs.buffered.QueueBufferConfig;
import com.amazonaws.services.sqs.buffered.QueueBufferFuture;
import com.amazonaws.services.sqs.buffered.ReceiveQueueBuffer;
import com.amazonaws.services.sqs.buffered.SendQueueBuffer;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class QueueBuffer {
    private final SendQueueBuffer sendBuffer;
    private final ReceiveQueueBuffer receiveBuffer;
    private final AmazonSQSAsync realSqs;
    QueueBufferConfig config;
    static ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory());

    QueueBuffer(QueueBufferConfig paramConfig, String url, AmazonSQSAsync sqs) {
        this.realSqs = sqs;
        this.config = paramConfig;
        this.sendBuffer = new SendQueueBuffer(sqs, executor, paramConfig, url);
        this.receiveBuffer = new ReceiveQueueBuffer(sqs, executor, paramConfig, url);
    }

    public Future<SendMessageResult> sendMessage(SendMessageRequest request, AsyncHandler<SendMessageRequest, SendMessageResult> handler) {
        QueueBufferCallback<SendMessageRequest, SendMessageResult> callback = null;
        if (handler != null) {
            callback = new QueueBufferCallback<SendMessageRequest, SendMessageResult>(handler, request);
        }
        QueueBufferFuture<SendMessageRequest, SendMessageResult> future = this.sendBuffer.sendMessage(request, callback);
        future.setBuffer(this);
        return future;
    }

    public SendMessageResult sendMessageSync(SendMessageRequest request) {
        Future<SendMessageResult> future = this.sendMessage(request, null);
        return this.waitForFuture(future);
    }

    public Future<Void> deleteMessage(DeleteMessageRequest request, AsyncHandler<DeleteMessageRequest, Void> handler) {
        QueueBufferCallback<DeleteMessageRequest, Void> callback = null;
        if (handler != null) {
            callback = new QueueBufferCallback<DeleteMessageRequest, Void>(handler, request);
        }
        QueueBufferFuture<DeleteMessageRequest, Void> future = this.sendBuffer.deleteMessage(request, callback);
        future.setBuffer(this);
        return future;
    }

    public void deleteMessageSync(DeleteMessageRequest request) {
        Future<Void> future = this.deleteMessage(request, null);
        this.waitForFuture(future);
    }

    public Future<Void> changeMessageVisibility(ChangeMessageVisibilityRequest request, AsyncHandler<ChangeMessageVisibilityRequest, Void> handler) {
        QueueBufferCallback<ChangeMessageVisibilityRequest, Void> callback = null;
        if (handler != null) {
            callback = new QueueBufferCallback<ChangeMessageVisibilityRequest, Void>(handler, request);
        }
        QueueBufferFuture<ChangeMessageVisibilityRequest, Void> future = this.sendBuffer.changeMessageVisibility(request, callback);
        future.setBuffer(this);
        return future;
    }

    public void changeMessageVisibilitySync(ChangeMessageVisibilityRequest request) {
        QueueBufferFuture<ChangeMessageVisibilityRequest, Void> future = this.sendBuffer.changeMessageVisibility(request, null);
        this.waitForFuture(future);
    }

    public Future<ReceiveMessageResult> receiveMessage(ReceiveMessageRequest rq, AsyncHandler<ReceiveMessageRequest, ReceiveMessageResult> handler) {
        boolean bufferngEnabled;
        boolean noAttributes = rq.getAttributeNames() == null || rq.getAttributeNames().isEmpty();
        boolean noMessageAttributesToRetrieve = rq.getMessageAttributeNames() == null || rq.getMessageAttributeNames().isEmpty();
        boolean bl = bufferngEnabled = this.config.getMaxInflightReceiveBatches() > 0 && this.config.getMaxDoneReceiveBatches() > 0;
        if (noMessageAttributesToRetrieve && noAttributes && bufferngEnabled && rq.getVisibilityTimeout() == null) {
            QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResult> callback = null;
            if (handler != null) {
                callback = new QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResult>(handler, rq);
            }
            QueueBufferFuture<ReceiveMessageRequest, ReceiveMessageResult> future = this.receiveBuffer.receiveMessageAsync(rq, callback);
            future.setBuffer(this);
            return future;
        }
        return this.realSqs.receiveMessageAsync(rq);
    }

    public ReceiveMessageResult receiveMessageSync(ReceiveMessageRequest rq) {
        Future<ReceiveMessageResult> future = this.receiveMessage(rq, null);
        return this.waitForFuture(future);
    }

    public void shutdown() {
        this.receiveBuffer.shutdown();
    }

    private <ResultType> ResultType waitForFuture(Future<ResultType> future) {
        ResultType toReturn = null;
        try {
            toReturn = future.get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            AmazonClientException ce = new AmazonClientException("Thread interrupted while waiting for execution result");
            ce.initCause(ie);
            throw ce;
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof AmazonClientException) {
                throw (AmazonClientException)cause;
            }
            AmazonClientException ce = new AmazonClientException("Caught an exception while waiting for request to complete...");
            ce.initCause(ee);
            throw ce;
        }
        return toReturn;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        static AtomicInteger threadCount = new AtomicInteger(0);

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            int threadNumber = threadCount.addAndGet(1);
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("SQSQueueBufferWorkerThread-" + threadNumber);
            return thread;
        }
    }
}

