/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.duracloud.account.compute.ComputeProviderUtil;
import org.duracloud.account.compute.DuracloudComputeProvider;
import org.duracloud.account.compute.error.DuracloudInstanceNotAvailableException;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.ComputeProviderAccount;
import org.duracloud.account.db.model.DuracloudInstance;
import org.duracloud.account.db.model.InstanceType;
import org.duracloud.account.db.model.ServerDetails;
import org.duracloud.account.db.model.ServerImage;
import org.duracloud.account.db.repo.DuracloudInstanceRepo;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.repo.DuracloudServerImageRepo;
import org.duracloud.account.db.util.DuracloudInstanceManagerService;
import org.duracloud.account.db.util.DuracloudInstanceService;
import org.duracloud.account.db.util.DuracloudInstanceServiceFactory;
import org.duracloud.account.db.util.error.DuracloudInstanceCreationException;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuracloudInstanceManagerServiceImpl
implements DuracloudInstanceManagerService {
    private Logger log = LoggerFactory.getLogger(DuracloudInstanceManagerServiceImpl.class);
    private static final String HOST_SUFFIX = ".duracloud.org";
    private DuracloudRepoMgr repoMgr;
    private ComputeProviderUtil computeUtil;
    private DuracloudInstanceServiceFactory instanceServiceFactory;

    public DuracloudInstanceManagerServiceImpl(DuracloudRepoMgr repoMgr, ComputeProviderUtil computeUtil, DuracloudInstanceServiceFactory instanceServiceFactory) {
        this.repoMgr = repoMgr;
        this.computeUtil = computeUtil;
        this.instanceServiceFactory = instanceServiceFactory;
    }

    @Override
    public Set<String> getVersions() {
        Set<ServerImage> serverImages = this.getServerImages();
        HashSet<String> versions = new HashSet<String>();
        for (ServerImage image : serverImages) {
            versions.add(image.getVersion());
        }
        return versions;
    }

    @Override
    public String getLatestVersion() {
        DuracloudServerImageRepo imageRepo = this.repoMgr.getServerImageRepo();
        ServerImage image = imageRepo.findLatest();
        return image.getVersion();
    }

    private Set<ServerImage> getServerImages() {
        DuracloudServerImageRepo imageRepo = this.repoMgr.getServerImageRepo();
        List images = imageRepo.findAll();
        HashSet<ServerImage> serverImages = new HashSet<ServerImage>();
        serverImages.addAll(images);
        return serverImages;
    }

    @Override
    public DuracloudInstanceService createInstance(Long accountId, String version, InstanceType instanceType) {
        Set<ServerImage> serverImages = this.getServerImages();
        for (ServerImage image : serverImages) {
            if (!version.equals(image.getVersion())) continue;
            return this.createInstance(accountId, image, instanceType);
        }
        String err = "The DuraCloud version " + version + " is not available";
        throw new DuracloudInstanceCreationException(err);
    }

    private DuracloudInstanceService createInstance(Long accountId, ServerImage image, InstanceType instanceType) {
        this.log.info("Creating new instance for account {} using image {} ", (Object)accountId, (Object)image.getDescription());
        DuracloudInstance instance = this.doCreateInstance(accountId, image, instanceType);
        return this.initializeInstance(instance);
    }

    protected DuracloudInstance doCreateInstance(Long accountId, ServerImage image, InstanceType instanceType) {
        AccountInfo account = (AccountInfo)this.repoMgr.getAccountRepo().findOne(accountId);
        String hostName = account.getSubdomain() + HOST_SUFFIX;
        DuracloudInstance instance = new DuracloudInstance();
        instance.setImage(image);
        instance.setAccount(account);
        instance.setHostName(hostName);
        instance.setProviderInstanceId(DuracloudInstance.PLACEHOLDER_PROVIDER_ID);
        instance.setInitialized(false);
        ServerDetails serverDetails = account.getServerDetails();
        if (serverDetails == null) {
            String err = "Cannot start instance for account with ID " + accountId + ". No ServerDetails are associated with this account.";
            throw new DuraCloudRuntimeException(err);
        }
        ComputeProviderAccount computeProviderAcct = serverDetails.getComputeProviderAccount();
        DuracloudComputeProvider computeProvider = this.computeUtil.getComputeProvider(computeProviderAcct.getUsername(), computeProviderAcct.getPassword());
        String providerInstanceId = null;
        try {
            providerInstanceId = computeProvider.start(image.getProviderImageId(), image.getIamRole(), computeProviderAcct.getSecurityGroup(), computeProviderAcct.getKeypair(), computeProviderAcct.getElasticIp(), instanceType, account.getSubdomain() + HOST_SUFFIX);
        }
        catch (RuntimeException ex) {
            throw new DuraCloudRuntimeException(ex.getMessage(), ex);
        }
        instance.setProviderInstanceId(providerInstanceId);
        return this.repoMgr.getInstanceRepo().save(instance);
    }

    private DuracloudInstanceService initializeInstance(DuracloudInstance instance) {
        DuracloudInstanceService instanceService = this.instanceServiceFactory.getInstance(instance);
        instanceService.initialize();
        return instanceService;
    }

    @Override
    public DuracloudInstanceService getInstanceService(Long instanceId) throws DuracloudInstanceNotAvailableException {
        DuracloudInstanceService instanceService = null;
        DuracloudInstanceRepo instanceRepo = this.repoMgr.getInstanceRepo();
        DuracloudInstance instance = (DuracloudInstance)instanceRepo.findOne(instanceId);
        instanceService = this.instanceServiceFactory.getInstance(instance);
        try {
            instanceService.getStatusInternal();
        }
        catch (DuracloudInstanceNotAvailableException e) {
            this.log.warn("Instance {} does not exist, deleting.", (Object)instanceId);
            instanceRepo.delete(instanceId);
            throw e;
        }
        return instanceService;
    }

    @Override
    public Set<DuracloudInstanceService> getInstanceServices(Long accountId) {
        List<DuracloudInstance> instances = this.getInstances(accountId);
        HashSet<DuracloudInstanceService> instanceServices = new HashSet<DuracloudInstanceService>();
        if (null != instances) {
            for (DuracloudInstance instance : instances) {
                try {
                    instanceServices.add(this.getInstanceService(instance.getId()));
                }
                catch (DuracloudInstanceNotAvailableException e) {
                    this.log.error("The instance with ID: " + instance.getId() + " was found to be associated with the " + "account with ID: " + accountId + " but the instance could not be found!");
                }
            }
        }
        return instanceServices;
    }

    private List<DuracloudInstance> getInstances(Long accountId) {
        DuracloudInstanceRepo instanceRepo = this.repoMgr.getInstanceRepo();
        return instanceRepo.findByAccountId(accountId);
    }
}

