/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.duplication.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DuplicationInfo {
    private String host;
    private Map<String, Store> stores;
    private List<String> issues;

    public DuplicationInfo(String host) {
        this.host = host;
        this.stores = new HashMap<String, Store>();
        this.issues = new ArrayList<String>();
    }

    public void addIssue(String issue) {
        this.issues.add(issue);
    }

    public List<String> getIssues() {
        return this.issues;
    }

    public boolean hasIssues() {
        return this.issues.size() > 0;
    }

    public void addSpaceCount(String storeId, String spaceId, long count) {
        this.checkStore(storeId);
        this.stores.get(storeId).addSpace(spaceId, count);
    }

    private void checkStore(String storeId) {
        if (!this.stores.containsKey(storeId)) {
            this.stores.put(storeId, new Store(storeId));
        }
    }

    public String getHost() {
        return this.host;
    }

    public Set<String> getStoreIds() {
        return this.stores.keySet();
    }

    public Map<String, Long> getSpaceCounts(String storeId) {
        this.checkStore(storeId);
        return this.stores.get(storeId).getSpaceCounts();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("https://");
        sb.append(this.host);
        sb.append(" status: ");
        if (this.issues.size() == 0) {
            sb.append("OK");
        } else {
            sb.append("ISSUES REPORTED:");
            for (String issue : this.issues) {
                sb.append("\n");
                sb.append(issue);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    private class Store {
        private String storeId;
        private Map<String, Long> spaceCounts;

        public Store(String storeId) {
            this.storeId = storeId;
            this.spaceCounts = new HashMap<String, Long>();
        }

        public String getStoreId() {
            return this.storeId;
        }

        public void addSpace(String spaceId, long count) {
            this.spaceCounts.put(spaceId, count);
        }

        public Map<String, Long> getSpaceCounts() {
            return this.spaceCounts;
        }
    }
}

