/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.sns.impl;

import com.amazonaws.services.sns.AmazonSNSClient;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.duracloud.account.db.model.GlobalProperties;
import org.duracloud.account.db.repo.GlobalPropertiesRepo;
import org.duracloud.common.event.AccountChangeEvent;
import org.duracloud.common.sns.AccountChangeNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="accountChangeNotifier")
public class AccountChangeNotifierImpl
implements AccountChangeNotifier {
    private AmazonSNSClient snsClient = new AmazonSNSClient();
    private GlobalPropertiesRepo globalPropertiesRepo;
    private static Logger log = LoggerFactory.getLogger(AccountChangeNotifierImpl.class);

    @Autowired
    public AccountChangeNotifierImpl(GlobalPropertiesRepo globalPropertiesRepo) {
        this.globalPropertiesRepo = globalPropertiesRepo;
    }

    @Override
    public void accountChanged(String account) {
        this.publish(AccountChangeEvent.EventType.ACCOUNT_CHANGED, account);
    }

    private void publish(AccountChangeEvent.EventType eventType, String account) {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.warn("unable to resolve unknown host: " + e.getMessage(), e);
            host = "unknown";
        }
        AccountChangeEvent event = new AccountChangeEvent(eventType, account, host);
        try {
            log.debug("publishing event={}", (Object)event);
            GlobalProperties props = (GlobalProperties)this.globalPropertiesRepo.findAll().get(0);
            this.snsClient.publish(props.getInstanceNotificationTopicArn(), AccountChangeEvent.serialize(event));
            log.info("published event={}", (Object)event);
        }
        catch (Exception e) {
            log.error("Failed to publish event: " + event + " : " + e.getMessage(), e);
        }
    }

    @Override
    public void storageProvidersChanged(String accountId) {
        this.publish(AccountChangeEvent.EventType.STORAGE_PROVIDERS_CHANGED, accountId);
    }

    @Override
    public void userStoreChanged(String accountId) {
        this.publish(AccountChangeEvent.EventType.USERS_CHANGED, accountId);
    }

    @Override
    public void rootUsersChanged() {
        this.publish(AccountChangeEvent.EventType.ACCOUNT_CHANGED, null);
    }

    @Override
    public void storageProviderCacheOnNodeChanged(String account) {
        this.publish(AccountChangeEvent.EventType.STORAGE_PROVIDER_CACHE_ON_NODE_CHANGED, account);
    }
}

