/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.util.ArrayList;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.UriTemplate;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class PagedResourcesAssembler<T>
implements ResourceAssembler<Page<T>, PagedResources<Resource<T>>> {
    private final HateoasPageableHandlerMethodArgumentResolver pageableResolver;
    private final UriComponents baseUri;

    public PagedResourcesAssembler(HateoasPageableHandlerMethodArgumentResolver resolver, UriComponents baseUri) {
        this.pageableResolver = resolver == null ? new HateoasPageableHandlerMethodArgumentResolver() : resolver;
        this.baseUri = baseUri;
    }

    public PagedResources<Resource<T>> toResource(Page<T> entity) {
        return this.toResource(entity, new SimplePagedResourceAssembler());
    }

    public PagedResources<Resource<T>> toResource(Page<T> page, Link selfLink) {
        return this.toResource(page, new SimplePagedResourceAssembler(), selfLink);
    }

    public <R extends ResourceSupport> PagedResources<R> toResource(Page<T> page, ResourceAssembler<T, R> assembler) {
        return this.createResource(page, assembler, null);
    }

    public <R extends ResourceSupport> PagedResources<R> toResource(Page<T> page, ResourceAssembler<T, R> assembler, Link link) {
        Assert.notNull(link, "Link must not be null!");
        return this.createResource(page, assembler, link);
    }

    public Link appendPaginationParameterTemplates(Link link) {
        Assert.notNull(link, "Link must not be null!");
        String uri = link.getHref();
        UriTemplate uriTemplate = new UriTemplate(uri);
        UriComponents uriComponents = UriComponentsBuilder.fromUriString(uri).build();
        TemplateVariables variables = this.pageableResolver.getPaginationTemplateVariables(this.getMethodParameter(), uriComponents);
        return new Link(uriTemplate.with(variables), link.getRel());
    }

    private <S, R extends ResourceSupport> PagedResources<R> createResource(Page<S> page, ResourceAssembler<S, R> assembler, Link link) {
        Assert.notNull(page, "Page must not be null!");
        Assert.notNull(assembler, "ResourceAssembler must not be null!");
        ArrayList<ResourceSupport> resources = new ArrayList<ResourceSupport>(page.getNumberOfElements());
        for (Object element : page) {
            resources.add(assembler.toResource(element));
        }
        PagedResources pagedResources = new PagedResources(resources, PagedResourcesAssembler.asPageMetadata(page), new Link[0]);
        return this.addPaginationLinks(pagedResources, page, link == null ? this.getDefaultUriString().toUriString() : link.getHref());
    }

    private UriComponents getDefaultUriString() {
        return this.baseUri == null ? ServletUriComponentsBuilder.fromCurrentRequest().build() : this.baseUri;
    }

    private <R extends ResourceSupport> PagedResources<R> addPaginationLinks(PagedResources<R> resources, Page<?> page, String uri) {
        if (page.hasNext()) {
            this.foo(resources, page.nextPageable(), uri, "next");
        }
        if (page.hasPrevious()) {
            this.foo(resources, page.previousPageable(), uri, "prev");
        }
        resources.add(this.appendPaginationParameterTemplates(new Link(uri)));
        return resources;
    }

    private void foo(PagedResources<?> resources, Pageable pageable, String uri, String rel) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(uri);
        this.pageableResolver.enhance(builder, this.getMethodParameter(), pageable);
        resources.add(new Link(builder.build().toUriString(), rel));
    }

    protected MethodParameter getMethodParameter() {
        return null;
    }

    private static <T> PagedResources.PageMetadata asPageMetadata(Page<T> page) {
        Assert.notNull(page, "Page must not be null!");
        return new PagedResources.PageMetadata((long)page.getSize(), (long)page.getNumber(), page.getTotalElements(), (long)page.getTotalPages());
    }

    private static class SimplePagedResourceAssembler<T>
    implements ResourceAssembler<T, Resource<T>> {
        private SimplePagedResourceAssembler() {
        }

        public Resource<T> toResource(T entity) {
            return new Resource(entity, new Link[0]);
        }
    }
}

