/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.duplication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.account.db.util.GlobalPropertiesConfigService;
import org.duracloud.account.db.util.error.DBNotFoundException;
import org.duracloud.account.monitor.common.BaseMonitor;
import org.duracloud.account.monitor.duplication.domain.DuplicationInfo;
import org.duracloud.account.monitor.duplication.domain.DuplicationReport;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.client.ContentStoreManagerImpl;
import org.duracloud.common.model.Credential;
import org.duracloud.error.ContentStoreException;
import org.duracloud.storage.util.StorageProviderUtil;
import org.slf4j.LoggerFactory;

public class DuplicationMonitor
extends BaseMonitor {
    public static final String ALL_SPACES = "ALL";
    private static final String PORT = "443";
    private static final String CONTEXT = "durastore";
    private static final List<String> ADMIN_SPACES = Arrays.asList("x-duracloud-admin", "x-service-out");
    private Map<String, String> dupHosts;

    public DuplicationMonitor(DuracloudAccountRepo acctRepo, GlobalPropertiesConfigService configService, Map<String, String> dupHosts) {
        this.log = LoggerFactory.getLogger(DuplicationMonitor.class);
        super.init(acctRepo, configService);
        this.dupHosts = dupHosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DuplicationReport monitorDuplication() {
        this.log.info("starting duplication monitor");
        DuplicationReport report = new DuplicationReport();
        for (String host : this.dupHosts.keySet()) {
            DuplicationInfo info = new DuplicationInfo(host);
            try {
                ContentStoreManager storeManager = this.getStoreManager(host);
                ContentStore primary = storeManager.getPrimaryContentStore();
                String primaryStoreId = primary.getStoreId();
                List<ContentStore> secondaryList = this.getSecondaryStores(storeManager, primaryStoreId);
                List<String> primarySpaces = this.getSpaces(host, primary);
                this.countSpaces(host, info, primary, primarySpaces, true);
                for (ContentStore secondary : secondaryList) {
                    List<String> secondarySpaces = this.getSpaces(host, secondary);
                    if (primarySpaces.size() != secondarySpaces.size()) {
                        info.addIssue("The spaces listings do not match between primary and secondary provider: " + secondary.getStorageProviderType());
                    }
                    this.countSpaces(host, info, secondary, secondarySpaces, false);
                }
                this.compareSpaces(primaryStoreId, info);
            }
            catch (Exception e) {
                String error = e.getClass() + " exception encountered while " + "running dup monitor for host " + host + ". Exception message: " + e.getMessage();
                this.log.error(error);
                info.addIssue(error);
            }
            finally {
                report.addDupInfo(host, info);
            }
        }
        return report;
    }

    private ContentStoreManager getStoreManager(String host) throws DBNotFoundException {
        ContentStoreManagerImpl storeManager = new ContentStoreManagerImpl(host, PORT, CONTEXT);
        AccountInfo account = this.getAccount(host);
        Credential credential = this.getRootCredential();
        storeManager.login(credential);
        return storeManager;
    }

    protected List<ContentStore> getSecondaryStores(ContentStoreManager storeManager, String primaryStoreId) throws ContentStoreException {
        HashMap<String, ContentStore> stores = new HashMap<String, ContentStore>(storeManager.getContentStores());
        ArrayList<ContentStore> secondaryStores = new ArrayList<ContentStore>();
        for (ContentStore store : stores.values()) {
            if (store.getStoreId().equals(primaryStoreId)) continue;
            secondaryStores.add(store);
        }
        return secondaryStores;
    }

    protected List<String> getSpaces(String host, ContentStore store) throws ContentStoreException {
        List<String> spaceList;
        String spaces = this.dupHosts.get(host);
        if (spaces.equals(ALL_SPACES)) {
            spaceList = new ArrayList<String>(store.getSpaces());
            spaceList.removeAll(ADMIN_SPACES);
        } else {
            String[] spacesToCompare = spaces.split(",");
            spaceList = Arrays.asList(spacesToCompare);
        }
        return spaceList;
    }

    protected void countSpaces(String host, DuplicationInfo info, ContentStore store, List<String> spaces, boolean primary) {
        String storeId = store.getStoreId();
        String storeType = store.getStorageProviderType();
        for (String spaceId : spaces) {
            boolean doCount = false;
            if (spaceId.indexOf(":") > -1) {
                String[] spaceAndStoreId = spaceId.split(":");
                spaceId = spaceAndStoreId[0];
                if (primary || storeId.equals(spaceAndStoreId[1])) {
                    doCount = true;
                }
            } else {
                doCount = true;
            }
            if (!doCount) continue;
            this.countSpace(host, spaceId, storeId, storeType, info, store);
        }
    }

    private void countSpace(String host, String spaceId, String storeId, String storeType, DuplicationInfo info, ContentStore store) {
        try {
            this.log.info("Counting space '" + spaceId + "' in store " + storeType + " for host " + host + " ...");
            long count = this.getSpaceCount(store, spaceId);
            this.log.info("Count for space '" + spaceId + "' in store " + storeType + " for host " + host + ": " + count);
            info.addSpaceCount(storeId, spaceId, count);
        }
        catch (ContentStoreException e) {
            String error = "ContentStoreException encountered attempting to get count of space " + spaceId + " for duplication check of host " + host + ". Exception message: " + e.getMessage();
            this.log.error(error);
            info.addIssue(error);
            info.addSpaceCount(storeId, spaceId, -1L);
        }
    }

    private long getSpaceCount(ContentStore store, String spaceId) throws ContentStoreException {
        return StorageProviderUtil.count(store.getSpaceContents(spaceId));
    }

    protected void compareSpaces(String primaryStoreId, DuplicationInfo info) {
        String spaces = this.dupHosts.get(info.getHost());
        Map<String, Long> primarySpaces = info.getSpaceCounts(primaryStoreId);
        for (String storeId : info.getStoreIds()) {
            Map<String, Long> secondarySpaces = info.getSpaceCounts(storeId);
            for (String spaceId : primarySpaces.keySet()) {
                boolean doCompare = false;
                if (null == spaces || spaces.equals(ALL_SPACES)) {
                    doCompare = true;
                } else {
                    String[] spacesToCompare = spaces.split(",");
                    List<String> spaceList = Arrays.asList(spacesToCompare);
                    if (spaceList.contains(spaceId)) {
                        doCompare = true;
                    } else {
                        for (String spacesSpaceId : spaceList) {
                            String[] spaceAndStoreId = spacesSpaceId.split(":");
                            if (!spaceId.equals(spaceAndStoreId[0]) || !storeId.equals(spaceAndStoreId[1])) continue;
                            doCompare = true;
                        }
                    }
                }
                if (!doCompare) continue;
                Long primaryCount = primarySpaces.get(spaceId);
                Long secondaryCount = secondarySpaces.get(spaceId);
                if (null == secondaryCount) {
                    info.addIssue("The secondary provider (ID=" + storeId + ") is missing space: " + spaceId);
                    continue;
                }
                if (primaryCount.equals(secondaryCount)) continue;
                info.addIssue("The content item counts for the space " + spaceId + " do not match between primary and secondary " + "providers. Primary count: " + primaryCount + ". Secondary (ID=" + storeId + ") " + "count: " + secondaryCount + ".");
            }
        }
    }
}

