/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sns.model.Subscription;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListSubscriptionsByTopicResult
implements Serializable,
Cloneable {
    private SdkInternalList<Subscription> subscriptions;
    private String nextToken;

    public List<Subscription> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new SdkInternalList();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(Collection<Subscription> subscriptions) {
        if (subscriptions == null) {
            this.subscriptions = null;
            return;
        }
        this.subscriptions = new SdkInternalList<Subscription>(subscriptions);
    }

    public ListSubscriptionsByTopicResult withSubscriptions(Subscription ... subscriptions) {
        if (this.subscriptions == null) {
            this.setSubscriptions(new SdkInternalList<Subscription>(subscriptions.length));
        }
        for (Subscription ele : subscriptions) {
            this.subscriptions.add(ele);
        }
        return this;
    }

    public ListSubscriptionsByTopicResult withSubscriptions(Collection<Subscription> subscriptions) {
        this.setSubscriptions(subscriptions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSubscriptionsByTopicResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubscriptions() != null) {
            sb.append("Subscriptions: " + this.getSubscriptions() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionsByTopicResult)) {
            return false;
        }
        ListSubscriptionsByTopicResult other = (ListSubscriptionsByTopicResult)obj;
        if (other.getSubscriptions() == null ^ this.getSubscriptions() == null) {
            return false;
        }
        if (other.getSubscriptions() != null && !other.getSubscriptions().equals(this.getSubscriptions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubscriptions() == null ? 0 : this.getSubscriptions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSubscriptionsByTopicResult clone() {
        try {
            return (ListSubscriptionsByTopicResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

