/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.ListKeysRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ListKeysRequestMarshaller
implements Marshaller<Request<ListKeysRequest>, ListKeysRequest> {
    @Override
    public Request<ListKeysRequest> marshall(ListKeysRequest listKeysRequest) {
        if (listKeysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListKeysRequest> request = new DefaultRequest<ListKeysRequest>(listKeysRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.ListKeys");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (listKeysRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listKeysRequest.getLimit().intValue());
            }
            if (listKeysRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listKeysRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

