/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.RetireGrantRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class RetireGrantRequestMarshaller
implements Marshaller<Request<RetireGrantRequest>, RetireGrantRequest> {
    @Override
    public Request<RetireGrantRequest> marshall(RetireGrantRequest retireGrantRequest) {
        if (retireGrantRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RetireGrantRequest> request = new DefaultRequest<RetireGrantRequest>(retireGrantRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.RetireGrant");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (retireGrantRequest.getGrantToken() != null) {
                jsonGenerator.writeFieldName("GrantToken").writeValue(retireGrantRequest.getGrantToken());
            }
            if (retireGrantRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(retireGrantRequest.getKeyId());
            }
            if (retireGrantRequest.getGrantId() != null) {
                jsonGenerator.writeFieldName("GrantId").writeValue(retireGrantRequest.getGrantId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

