/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.DuracloudGroup;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.DuracloudGroupService;
import org.duracloud.account.db.util.error.DuracloudGroupAlreadyExistsException;
import org.duracloud.account.db.util.error.DuracloudGroupNotFoundException;
import org.duracloud.account.db.util.error.InvalidGroupNameException;
import org.duracloud.common.sns.AccountChangeNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="duracloudGroupService")
public class DuracloudGroupServiceImpl
implements DuracloudGroupService {
    private Logger log = LoggerFactory.getLogger(DuracloudGroupServiceImpl.class);
    private DuracloudRepoMgr repoMgr;
    private AccountChangeNotifier accountChangeNotifier;

    @Autowired
    public DuracloudGroupServiceImpl(DuracloudRepoMgr duracloudRepoMgr, AccountChangeNotifier accountChangeNotifier) {
        this.repoMgr = duracloudRepoMgr;
        this.accountChangeNotifier = accountChangeNotifier;
    }

    @Override
    public Set<DuracloudGroup> getGroups(Long acctId) {
        List<DuracloudGroup> listGroups = this.repoMgr.getGroupRepo().findByAccountId(acctId);
        HashSet<DuracloudGroup> groups = new HashSet<DuracloudGroup>();
        groups.addAll(listGroups);
        return Collections.unmodifiableSet(groups);
    }

    @Override
    public DuracloudGroup getGroup(String name, Long acctId) {
        return this.repoMgr.getGroupRepo().findByNameAndAccountId(name, acctId);
    }

    @Override
    public DuracloudGroup createGroup(String name, Long acctId) throws DuracloudGroupAlreadyExistsException, InvalidGroupNameException {
        if (!this.isGroupNameValid(name)) {
            throw new InvalidGroupNameException(name);
        }
        if (this.groupExistsInAccount(name, acctId)) {
            throw new DuracloudGroupAlreadyExistsException(name);
        }
        AccountInfo accountInfo = (AccountInfo)this.repoMgr.getAccountRepo().findOne(acctId);
        DuracloudGroup group = new DuracloudGroup();
        group.setName(name);
        group.setAccount(accountInfo);
        group = this.repoMgr.getGroupRepo().save(group);
        return group;
    }

    protected final boolean isGroupNameValid(String name) {
        if (name == null) {
            return false;
        }
        if (!name.startsWith("group-")) {
            return false;
        }
        if ("group-public".equalsIgnoreCase(name)) {
            return false;
        }
        return name.substring("group-".length()).matches("\\A(?![_.@\\-])[a-z0-9_.@\\-]+(?<![_.@\\-])\\Z");
    }

    private boolean groupExistsInAccount(String name, Long acctId) {
        DuracloudGroup group = this.getGroup(name, acctId);
        return group != null;
    }

    @Override
    public void deleteGroup(DuracloudGroup group, Long acctId) {
        if (null == group) {
            this.log.warn("Arg group is null.");
            return;
        }
        this.repoMgr.getGroupRepo().delete(group.getId());
        this.propagateUpdate(acctId);
    }

    @Override
    public void updateGroupUsers(DuracloudGroup group, Set<DuracloudUser> users, Long acctId) throws DuracloudGroupNotFoundException {
        group.setUsers(users);
        this.repoMgr.getGroupRepo().save(group);
        this.propagateUpdate(acctId);
    }

    private void propagateUpdate(Long acctId) {
        try {
            AccountInfo account = (AccountInfo)this.repoMgr.getAccountRepo().getOne(acctId);
            this.accountChangeNotifier.userStoreChanged(account.getSubdomain());
        }
        catch (Exception ex) {
            this.log.error("failed to notify of change to account " + acctId, ex);
        }
    }
}

