/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.sns.config;

import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.Message;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.duracloud.account.db.model.GlobalProperties;
import org.duracloud.account.db.repo.GlobalPropertiesRepo;
import org.duracloud.common.cache.AccountComponentCache;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.event.AccountChangeEvent;
import org.duracloud.common.sns.MessageListener;
import org.duracloud.common.sns.SnsSubscriptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SnsSubscriptionManagerConfig {
    private Logger log = LoggerFactory.getLogger(SnsSubscriptionManagerConfig.class);

    @Bean(destroyMethod="disconnect", initMethod="connect")
    public SnsSubscriptionManager snsSubscriptionManager(GlobalPropertiesRepo globalPropertiesRepo, final List<AccountComponentCache<?>> componentCaches, String appName) {
        try {
            GlobalProperties props = (GlobalProperties)globalPropertiesRepo.findAll().get(0);
            String queueName = "node-queue-" + appName + "-" + Inet4Address.getLocalHost().getHostName().replace(".", "_");
            SnsSubscriptionManager subscriptionManager = new SnsSubscriptionManager(new AmazonSQSClient(), new AmazonSNSClient(), props.getInstanceNotificationTopicArn(), queueName);
            subscriptionManager.addListener(new MessageListener(){

                @Override
                public void onMessage(Message message) {
                    SnsSubscriptionManagerConfig.this.log.info("message received: " + message);
                    SnsSubscriptionManagerConfig.this.log.debug("message body: " + message.getBody());
                    JsonFactory factory = new JsonFactory();
                    ObjectMapper mapper = new ObjectMapper(factory);
                    TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
                    String body = message.getBody();
                    try {
                        Map map = (Map)mapper.readValue(body, (TypeReference)typeRef);
                        AccountChangeEvent event = AccountChangeEvent.deserialize((String)map.get("Message"));
                        for (AccountComponentCache cache : componentCaches) {
                            cache.onEvent(event);
                        }
                    }
                    catch (IOException e) {
                        SnsSubscriptionManagerConfig.this.log.warn("unable to dispatch message: " + message + " : " + e.getMessage(), e);
                    }
                }
            });
            return subscriptionManager;
        }
        catch (UnknownHostException e) {
            throw new DuraCloudRuntimeException(e);
        }
    }
}

