/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.duracloud.account.db.model.EmailTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailTemplateUtil {
    private static final Logger log = LoggerFactory.getLogger(EmailTemplateUtil.class);

    private EmailTemplateUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EmailTemplate loadDefault(EmailTemplate.Templates template) {
        try (BufferedReader reader = EmailTemplateUtil.getTemplate(template);){
            String subject = null;
            String body = null;
            String subjectLinePrefix = "email-subject:";
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.toLowerCase().startsWith("email-subject:")) continue;
                subject = line.substring("email-subject:".length());
                break;
            }
            String bodyPrefix = "email-body:";
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (!line.toLowerCase().startsWith("email-body:")) continue;
                builder.append(line.substring("email-body:".length()));
                break;
            }
            while ((line = reader.readLine()) != null) {
                builder.append("\n" + line);
            }
            body = builder.toString();
            EmailTemplate emailTemplate = new EmailTemplate();
            emailTemplate.setTemplate(template);
            emailTemplate.setSubject(subject);
            emailTemplate.setBody(body);
            EmailTemplate emailTemplate2 = emailTemplate;
            return emailTemplate2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static BufferedReader getTemplate(EmailTemplate.Templates template) {
        return new BufferedReader(new InputStreamReader(EmailTemplateUtil.class.getResourceAsStream("/templates/" + template.getTemplateName() + ".txt")));
    }

    public static String format(Map<String, String> parameters, String outputString) {
        for (String key : parameters.keySet()) {
            outputString = outputString.replace("${" + key + "}", parameters.get(key));
        }
        return outputString;
    }
}

