/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.changenotifier;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.SubscribeResult;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.QueueNameExistsException;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.duracloud.common.changenotifier.MessageListener;
import org.duracloud.common.changenotifier.SubscriptionManager;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.util.WaitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnsSubscriptionManager
implements SubscriptionManager {
    private Logger log = LoggerFactory.getLogger(SnsSubscriptionManager.class);
    private AmazonSQS sqsClient;
    private AmazonSNS snsClient;
    private String topicArn;
    private String queueName;
    private String queueUrl;
    private String subscriptionArn;
    private boolean initialized = false;
    private List<MessageListener> messageListeners = new ArrayList<MessageListener>();

    public SnsSubscriptionManager(AmazonSQS sqsClient, AmazonSNS snsClient, String topicArn, String queueName) {
        this.topicArn = topicArn;
        this.queueName = queueName;
        this.sqsClient = sqsClient;
        this.snsClient = snsClient;
    }

    @Override
    public void addListener(MessageListener listener) {
        this.messageListeners.add(listener);
    }

    @Override
    public synchronized void connect() {
        if (this.initialized) {
            throw new DuraCloudRuntimeException("this manager is already connected");
        }
        this.log.info("creating sqs queue");
        CreateQueueRequest request = new CreateQueueRequest(this.queueName);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ReceiveMessageWaitTimeSeconds", "20");
        request.setAttributes(attributes);
        try {
            CreateQueueResult result = this.sqsClient.createQueue(request);
            this.queueUrl = result.getQueueUrl();
            this.log.info("sqs queue created: {}", (Object)this.queueUrl);
        }
        catch (QueueNameExistsException ex) {
            this.log.info("queue with name {} already exists.");
            GetQueueUrlResult queueUrlResult = this.sqsClient.getQueueUrl(this.queueName);
            this.queueUrl = queueUrlResult.getQueueUrl();
            this.log.info("sqs queue url retrieved: {}", (Object)this.queueUrl);
        }
        String queueArnKey = "QueueArn";
        GetQueueAttributesResult getQueueAttrResult = this.sqsClient.getQueueAttributes(this.queueUrl, Arrays.asList(queueArnKey));
        this.log.info("subscribing {} to {}", (Object)this.queueUrl, (Object)this.topicArn);
        String queueArn = getQueueAttrResult.getAttributes().get(queueArnKey);
        SubscribeResult subscribeResult = this.snsClient.subscribe(this.topicArn, "sqs", queueArn);
        this.subscriptionArn = subscribeResult.getSubscriptionArn();
        HashMap<String, String> queueAttributes = new HashMap<String, String>();
        queueAttributes.put("Policy", this.generateSqsPolicyForTopic(queueArn, this.topicArn));
        this.sqsClient.setQueueAttributes(new SetQueueAttributesRequest(this.queueUrl, queueAttributes));
        this.log.info("subscription complete: {}", (Object)this.subscriptionArn);
        this.initialized = true;
        this.startPolling();
    }

    private String generateSqsPolicyForTopic(String queueArn, String topicArn) {
        String policy = "{   \"Version\":\"2008-10-17\",  \"Id\":\"" + queueArn + "/policyId\",  \"Statement\": [    {        \"Sid\":\"" + queueArn + "/statementId\",        \"Effect\":\"Allow\",        \"Principal\":{\"AWS\":\"*\"},        \"Action\":\"SQS:SendMessage\",        \"Resource\": \"" + queueArn + "\",        \"Condition\":{            \"StringEquals\":{\"aws:SourceArn\":\"" + topicArn + "\"}        }    }  ]}";
        return policy;
    }

    private void startPolling() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (SnsSubscriptionManager.this.initialized) {
                    try {
                        ReceiveMessageResult result = SnsSubscriptionManager.this.sqsClient.receiveMessage(SnsSubscriptionManager.this.queueUrl);
                        List<Message> messages = result.getMessages();
                        for (Message message : messages) {
                            SnsSubscriptionManager.this.dispatch(message);
                            SnsSubscriptionManager.this.log.debug("{} dispatched", (Object)message);
                            SnsSubscriptionManager.this.sqsClient.deleteMessage(SnsSubscriptionManager.this.queueUrl, message.getReceiptHandle());
                            SnsSubscriptionManager.this.log.debug("{} deleted", (Object)message);
                        }
                    }
                    catch (Exception ex) {
                        SnsSubscriptionManager.this.log.warn("failed to poll queue: " + ex.getMessage(), ex);
                    }
                }
            }
        }, "sqs-long-poller").start();
    }

    private void dispatch(Message message) {
        this.log.debug("dispatching message {}", (Object)message);
        for (MessageListener listener : this.messageListeners) {
            try {
                listener.onMessage(message);
            }
            catch (Exception ex) {
                this.log.error("failed to dispatch message " + message + " to " + listener + "due to " + ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void disconnect() {
        if (!this.initialized) {
            throw new DuraCloudRuntimeException("this manager is already disconnected");
        }
        this.log.info("disconnecting");
        this.log.info("unsubscribing {}", (Object)this.subscriptionArn);
        this.snsClient.unsubscribe(this.subscriptionArn);
        this.log.info("unsubscribed {}", (Object)this.subscriptionArn);
        this.log.info("deleting queue {}", (Object)this.subscriptionArn);
        this.sqsClient.deleteQueue(this.queueUrl);
        this.log.info("deleted queue {}", (Object)this.subscriptionArn);
        this.initialized = false;
        WaitUtil.wait(60);
        this.log.info("disconnection complete");
    }
}

