/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;

public abstract class PageableExecutionUtils {
    private PageableExecutionUtils() {
    }

    public static <T> Page<T> getPage(List<T> content, Pageable pageable, TotalSupplier totalSupplier) {
        Assert.notNull(content, "Content must not be null!");
        Assert.notNull(totalSupplier, "TotalSupplier must not be null!");
        if (pageable == null || pageable.getOffset() == 0) {
            if (pageable == null || pageable.getPageSize() > content.size()) {
                return new PageImpl<T>(content, pageable, content.size());
            }
            return new PageImpl<T>(content, pageable, totalSupplier.get());
        }
        if (content.size() != 0 && pageable.getPageSize() > content.size()) {
            return new PageImpl<T>(content, pageable, pageable.getOffset() + content.size());
        }
        return new PageImpl<T>(content, pageable, totalSupplier.get());
    }

    public static interface TotalSupplier {
        public long get();
    }
}

