/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishBatchRequestEntry;
import com.amazonaws.services.sns.model.transform.MessageAttributeValueStaxUnmarshaller;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

public class PublishBatchRequestEntryStaxUnmarshaller
implements Unmarshaller<PublishBatchRequestEntry, StaxUnmarshallerContext> {
    private static PublishBatchRequestEntryStaxUnmarshaller instance;

    @Override
    public PublishBatchRequestEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        PublishBatchRequestEntry publishBatchRequestEntry = new PublishBatchRequestEntry();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return publishBatchRequestEntry;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    publishBatchRequestEntry.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Message", targetDepth)) {
                    publishBatchRequestEntry.setMessage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Subject", targetDepth)) {
                    publishBatchRequestEntry.setSubject(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MessageStructure", targetDepth)) {
                    publishBatchRequestEntry.setMessageStructure(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MessageAttributes/entry", targetDepth)) {
                    Map.Entry<String, MessageAttributeValue> entry = MessageAttributesMapEntryUnmarshaller.getInstance().unmarshall(context);
                    publishBatchRequestEntry.addMessageAttributesEntry(entry.getKey(), entry.getValue());
                    continue;
                }
                if (context.testExpression("MessageDeduplicationId", targetDepth)) {
                    publishBatchRequestEntry.setMessageDeduplicationId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("MessageGroupId", targetDepth)) continue;
                publishBatchRequestEntry.setMessageGroupId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return publishBatchRequestEntry;
    }

    public static PublishBatchRequestEntryStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PublishBatchRequestEntryStaxUnmarshaller();
        }
        return instance;
    }

    private static class MessageAttributesMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, MessageAttributeValue>, StaxUnmarshallerContext> {
        private static MessageAttributesMapEntryUnmarshaller instance;

        private MessageAttributesMapEntryUnmarshaller() {
        }

        @Override
        public Map.Entry<String, MessageAttributeValue> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry<String, MessageAttributeValue> entry = new MapEntry<String, MessageAttributeValue>();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Name", targetDepth)) {
                        entry.setKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Value", targetDepth)) continue;
                    entry.setValue(MessageAttributeValueStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static MessageAttributesMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new MessageAttributesMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

