/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.util.OnCommittedResponseWrapper;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class HeaderWriterFilter
extends OncePerRequestFilter {
    private final List<HeaderWriter> headerWriters;

    public HeaderWriterFilter(List<HeaderWriter> headerWriters) {
        Assert.notEmpty(headerWriters, "headerWriters cannot be null or empty");
        this.headerWriters = headerWriters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HeaderWriterResponse headerWriterResponse = new HeaderWriterResponse(request, response, this.headerWriters);
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)headerWriterResponse);
        }
        finally {
            headerWriterResponse.writeHeaders();
        }
    }

    static class HeaderWriterResponse
    extends OnCommittedResponseWrapper {
        private final HttpServletRequest request;
        private final List<HeaderWriter> headerWriters;

        HeaderWriterResponse(HttpServletRequest request, HttpServletResponse response, List<HeaderWriter> headerWriters) {
            super(response);
            this.request = request;
            this.headerWriters = headerWriters;
        }

        @Override
        protected void onResponseCommitted() {
            this.writeHeaders();
            this.disableOnResponseCommitted();
        }

        protected void writeHeaders() {
            if (this.isDisableOnResponseCommitted()) {
                return;
            }
            for (HeaderWriter headerWriter : this.headerWriters) {
                headerWriter.writeHeaders(this.request, this.getHttpResponse());
            }
        }

        private HttpServletResponse getHttpResponse() {
            return (HttpServletResponse)this.getResponse();
        }
    }
}

