/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.message;

import com.amazonaws.SdkBaseException;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.GuardedBy;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.http.apache.utils.ApacheUtils;
import com.amazonaws.internal.FIFOCache;
import com.amazonaws.services.sns.message.HttpException;
import com.amazonaws.services.sns.message.SigningCertUrlVerifier;
import com.amazonaws.services.sns.util.SignatureChecker;
import com.amazonaws.util.IOUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;

@ThreadSafe
@SdkInternalApi
class SignatureVerifier {
    private static final String SIGNING_CERT_URL = "SigningCertURL";
    private static final Pattern X509_PATTERN = Pattern.compile("^[\\s]*-----BEGIN [A-Z]+-----\\n[A-Za-z\\d+\\/\\n]+[=]{0,2}\\n-----END [A-Z]+-----[\\s]*$");
    private final HttpClient client;
    private final DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
    private final SignatureChecker signatureChecker = new SignatureChecker();
    private final SigningCertUrlVerifier signingCertUrlVerifier;
    private final String expectedCertCommonName;
    @GuardedBy(value="this")
    private final FIFOCache<PublicKey> certificateCache = new FIFOCache(2);

    SignatureVerifier(HttpClient client, String expectedSnsEndpoint, String expectedCertCommonName) {
        this.client = client;
        this.signingCertUrlVerifier = new SigningCertUrlVerifier(expectedSnsEndpoint);
        this.expectedCertCommonName = expectedCertCommonName;
    }

    void verifySignature(JsonNode messageJson) {
        if (!this.signatureChecker.verifySignature(this.toMap(messageJson), this.fetchPublicKey(messageJson))) {
            throw new SdkClientException("Signature in SNS message was invalid");
        }
    }

    private synchronized PublicKey fetchPublicKey(JsonNode messageJson) {
        URI certUrl = URI.create(messageJson.get(SIGNING_CERT_URL).asText());
        PublicKey publicKey = this.certificateCache.get(certUrl.toString());
        if (publicKey == null) {
            String certificateData = this.downloadCertWithRetries(certUrl);
            this.validateCertificateData(certificateData);
            publicKey = this.createPublicKey(certificateData);
            this.certificateCache.add(certUrl.toString(), publicKey);
        }
        return publicKey;
    }

    private String downloadCertWithRetries(URI certUrl) {
        try {
            return this.downloadCert(certUrl);
        }
        catch (SdkBaseException e) {
            if (this.isRetryable(e)) {
                return this.downloadCert(certUrl);
            }
            throw e;
        }
    }

    private boolean isRetryable(SdkBaseException e) {
        if (e.getCause() instanceof IOException) {
            return true;
        }
        if (e instanceof HttpException) {
            return ((HttpException)e).getStatusCode() / 100 == 5;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String downloadCert(URI certUrl) {
        String string;
        this.signingCertUrlVerifier.verifyCertUrl(certUrl);
        HttpResponse response = this.client.execute(new HttpGet(certUrl));
        if (!ApacheUtils.isRequestSuccessful(response)) throw new HttpException("Could not download the certificate from SNS", response);
        try {
            string = IOUtils.toString(response.getEntity().getContent());
        }
        catch (Throwable throwable) {
            try {
                response.getEntity().getContent().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SdkClientException("Unable to download SNS certificate from " + certUrl.toString(), e);
            }
        }
        response.getEntity().getContent().close();
        return string;
    }

    private Map<String, String> toMap(JsonNode messageJson) {
        HashMap<String, String> fields = new HashMap<String, String>(messageJson.size());
        Iterator<Map.Entry<String, JsonNode>> jsonFields = messageJson.fields();
        while (jsonFields.hasNext()) {
            Map.Entry<String, JsonNode> next = jsonFields.next();
            fields.put(next.getKey(), next.getValue().asText());
        }
        return fields;
    }

    private PublicKey createPublicKey(String cert) {
        try {
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream stream = new ByteArrayInputStream(cert.getBytes(Charset.forName("UTF-8")));
            X509Certificate cer = (X509Certificate)fact.generateCertificate(stream);
            this.validateCertificate(cer);
            return cer.getPublicKey();
        }
        catch (SdkBaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SdkClientException("Could not create public key from certificate", e);
        }
    }

    private void validateCertificate(X509Certificate cer) throws CertificateExpiredException, CertificateNotYetValidException {
        this.verifyHostname(cer);
        cer.checkValidity();
    }

    private void verifyHostname(X509Certificate cer) {
        try {
            this.hostnameVerifier.verify(this.expectedCertCommonName, cer);
        }
        catch (SSLException e) {
            throw new SdkClientException("Certificate does not match expected common name: " + this.expectedCertCommonName, e);
        }
    }

    private void validateCertificateData(String data) {
        Matcher m = X509_PATTERN.matcher(data);
        if (!m.matches()) {
            throw new SdkClientException("Certificate does not match expected X509 PEM format.");
        }
    }
}

