/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.duracloud.account.config.AmaEndpoint;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.AccountRights;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.model.UserInvitation;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.repo.DuracloudRightsRepo;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.db.util.EmailTemplateService;
import org.duracloud.account.db.util.error.DuracloudProviderAccountNotAvailableException;
import org.duracloud.account.db.util.notification.NotificationMgr;
import org.duracloud.account.db.util.notification.Notifier;
import org.duracloud.common.changenotifier.AccountChangeNotifier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.storage.domain.StorageProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountServiceImpl
implements AccountService {
    private Logger log = LoggerFactory.getLogger(AccountServiceImpl.class);
    private AccountInfo account;
    private DuracloudRepoMgr repoMgr;
    private AccountChangeNotifier accountChangeNotifier;
    private Notifier notifier;

    public AccountServiceImpl(AmaEndpoint amaEndpoint, AccountInfo acct, DuracloudRepoMgr repoMgr, AccountChangeNotifier accountChangeNotifier, NotificationMgr notificationMgr, EmailTemplateService emailTemplateService) {
        this.account = acct;
        this.repoMgr = repoMgr;
        this.accountChangeNotifier = accountChangeNotifier;
        this.notifier = new Notifier(notificationMgr.getEmailer(), amaEndpoint, emailTemplateService);
    }

    @Override
    public Set<DuracloudUser> getUsers() {
        DuracloudRightsRepo rightsRepo = this.repoMgr.getRightsRepo();
        HashSet<DuracloudUser> users = new HashSet<DuracloudUser>();
        List<AccountRights> rights = rightsRepo.findByAccountId(this.account.getId());
        for (AccountRights right : rights) {
            DuracloudUser user = right.getUser();
            user.getAccountRights().size();
            users.add(user);
        }
        return users;
    }

    @Override
    public Long getAccountId() {
        return this.account.getId();
    }

    @Override
    public AccountInfo retrieveAccountInfo() {
        return this.account;
    }

    @Override
    public StorageProviderAccount getPrimaryStorageProvider() {
        return this.retrieveAccountInfo().getPrimaryStorageProviderAccount();
    }

    @Override
    public Set<StorageProviderAccount> getSecondaryStorageProviders() {
        return this.retrieveAccountInfo().getSecondaryStorageProviderAccounts();
    }

    @Override
    public void addStorageProvider(StorageProviderType storageProviderType) {
        String accountId = this.account.getSubdomain();
        this.log.info("Adding storage provider of type {} to account {}", (Object)storageProviderType, (Object)accountId);
        StorageProviderAccount storageProviderAccount = new StorageProviderAccount();
        storageProviderAccount.setProviderType(storageProviderType);
        AccountInfo account = this.retrieveAccountInfo();
        account.getSecondaryStorageProviderAccounts().add(storageProviderAccount);
        this.saveAccountInfo(account);
    }

    @Override
    public void removeStorageProvider(Long storageProviderId) {
        String accountId = this.account.getSubdomain();
        this.log.info("Removing storage provider with ID {} from account {}", (Object)storageProviderId, (Object)accountId);
        StorageProviderAccount storageProviderAccount = (StorageProviderAccount)this.repoMgr.getStorageProviderAccountRepo().findOne(storageProviderId);
        AccountInfo accountInfo = this.retrieveAccountInfo();
        if (!accountInfo.getSecondaryStorageProviderAccounts().remove(storageProviderAccount)) {
            throw new DuracloudProviderAccountNotAvailableException("The storage provider account with ID " + storageProviderId + " is not associated with account with id " + this.account.getId() + " as a secondary storage provider.");
        }
        this.saveAccountInfo(accountInfo);
        this.repoMgr.getStorageProviderAccountRepo().delete(storageProviderId);
        this.accountChangeNotifier.storageProvidersChanged(accountId);
    }

    private void saveAccountInfo(AccountInfo accountInfo) {
        this.repoMgr.getAccountRepo().save(accountInfo);
    }

    @Override
    public void changePrimaryStorageProvider(Long storageProviderId) {
        String accountId = this.account.getSubdomain();
        this.log.info("Changing primary storage provider to {} from account {}", (Object)storageProviderId, (Object)accountId);
        AccountInfo accountInfo = this.retrieveAccountInfo();
        Set<StorageProviderAccount> secondaryAccounts = accountInfo.getSecondaryStorageProviderAccounts();
        boolean primaryProviderUpdated = false;
        for (StorageProviderAccount secondary : secondaryAccounts) {
            if (!secondary.getId().equals(storageProviderId)) continue;
            secondaryAccounts.remove(secondary);
            secondaryAccounts.add(accountInfo.getPrimaryStorageProviderAccount());
            accountInfo.setPrimaryStorageProviderAccount(secondary);
            accountInfo.setSecondaryStorageProviderAccounts(secondaryAccounts);
            this.saveAccountInfo(accountInfo);
            primaryProviderUpdated = true;
        }
        if (!primaryProviderUpdated) {
            throw new DuracloudProviderAccountNotAvailableException("The storage provider account with ID " + storageProviderId + " is not associated with account with id " + accountId + " as a secondary storage provider.");
        }
        this.accountChangeNotifier.storageProvidersChanged(accountId);
    }

    @Override
    public void storeAccountInfo(String acctName, String orgName, String department) {
        Object[] logInfo = new String[]{this.account.getSubdomain(), acctName, orgName, department};
        this.log.info("Updating info for account {}. Account Name: {}, Org Name: {}, Department: {}", logInfo);
        this.account.setAcctName(acctName);
        this.account.setOrgName(orgName);
        this.account.setDepartment(department);
        this.repoMgr.getAccountRepo().save(this.account);
    }

    @Override
    public void storeAccountStatus(AccountInfo.AccountStatus status) {
        this.log.info("Updating account status to {} for account {}", (Object)status.name(), (Object)this.account.getSubdomain());
        this.account.setStatus(status);
        this.repoMgr.getAccountRepo().save(this.account);
    }

    @Override
    public String getSubdomain() {
        return this.account.getSubdomain();
    }

    @Override
    public UserInvitation inviteUser(String emailAddress, String adminUsername) {
        this.log.info("Inviting user at address {} to account {}", (Object)emailAddress, (Object)this.account.getSubdomain());
        ChecksumUtil cksumUtil = new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
        String code = emailAddress + System.currentTimeMillis();
        String redemptionCode = cksumUtil.generateChecksum(code);
        int expirationDays = 14;
        UserInvitation userInvitation = new UserInvitation(null, this.account, this.account.getAcctName(), this.account.getOrgName(), this.account.getDepartment(), this.account.getSubdomain(), adminUsername, emailAddress, expirationDays, redemptionCode);
        this.repoMgr.getUserInvitationRepo().save(userInvitation);
        this.notifier.sendNotificationUserInvitation(userInvitation);
        return userInvitation;
    }

    @Override
    public Set<UserInvitation> getPendingInvitations() {
        List<UserInvitation> invitations = this.repoMgr.getUserInvitationRepo().findByAccountId(this.account.getId());
        Date now = new Date();
        HashSet<UserInvitation> pendingInvitations = new HashSet<UserInvitation>();
        for (UserInvitation ui : invitations) {
            if (ui.getExpirationDate().before(now)) {
                this.repoMgr.getUserInvitationRepo().delete(ui.getId());
                continue;
            }
            pendingInvitations.add(ui);
        }
        return pendingInvitations;
    }

    @Override
    public void deleteUserInvitation(Long invitationId) {
        this.log.info("Deleting user invitation with id {} from account {}", (Object)invitationId, (Object)this.account.getSubdomain());
        this.repoMgr.getUserInvitationRepo().delete(invitationId);
    }
}

